/*
 * Decompiled with CFR 0.152.
 */
package de.paradigmchange.asciidoc;

import de.paradigmchange.asciidoc.AsciidoctorJWriterSettingsModels;
import de.paradigmchange.asciidoc.AsciidoctorSettingsHelpers;
import de.paradigmchange.asciidoc.LicenseChecker;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AsciidoctorJWriterNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AsciidoctorJWriterNodeModel.class);
    private static boolean licensed = LicenseChecker.checkLicense();
    static final String SELECTED_COLUMN = "Selected column";
    static final String SELECTED_BACKEND = "Selected backend";
    static final String OUTPUT_PATH = "Output path";
    static final String OUTPUT_FILE = "Output file";
    static final String ADD_HEADER_FOOTER = "Header & Footer";
    static final String SELECTED_CSS_STYLESHEET = "Selected stylesheet";
    static final String CUSTOM_CSS_STYLESHEET = "Custom CSS stylesheet";
    static final String SELECTED_PDF_THEME = "Selected theme";
    static final String CUSTOM_PDF_THEME = "Custom pdf theme";
    private final SettingsModelString m_SelectedColumn = AsciidoctorJWriterSettingsModels.createColumnModel();
    private final SettingsModelString m_SelectedBackend = AsciidoctorJWriterSettingsModels.createBackendModel();
    private final SettingsModelString m_OutputPath = AsciidoctorJWriterSettingsModels.createOutpathModel();
    private final SettingsModelString m_OutputFile = AsciidoctorJWriterSettingsModels.createOutfileModel();
    private final SettingsModelBoolean m_HeaderFooter = AsciidoctorJWriterSettingsModels.createHeaderFooterModel();
    private final SettingsModelString m_SelectedStylesheet = AsciidoctorJWriterSettingsModels.createSelectedStylesheetModel();
    private final SettingsModelString m_CustomStylesheet = AsciidoctorJWriterSettingsModels.createCustomStylesheetModel();
    private final SettingsModelString m_SelectedTheme = AsciidoctorJWriterSettingsModels.createSelectedThemeModel();
    private final SettingsModelString m_CustomTheme = AsciidoctorJWriterSettingsModels.createCustomThemeModel();
    private Map<String, String> backendsMap = AsciidoctorSettingsHelpers.createBackendMap("AsciidoctorJWriter");
    private Map<String, String> stylesheetsMap = AsciidoctorSettingsHelpers.createAvailableStylesheetsMap(licensed);
    private Map<String, String> themesMap = AsciidoctorSettingsHelpers.createAvailableThemesMap(licensed);

    protected AsciidoctorJWriterNodeModel() {
        super(1, 0);
        this.m_SelectedTheme.setEnabled(false);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        LOGGER.info((Object)"Starting Asciidoc conversion...");
        LOGGER.debug((Object)"Reconfiguring Backend, Stylesheet (HTML) and Theme (PDF) from Dictionary...");
        this.m_SelectedBackend.setStringValue(this.backendsMap.get(this.m_SelectedBackend.getStringValue()));
        this.m_SelectedStylesheet.setStringValue(this.stylesheetsMap.get(this.m_SelectedStylesheet.getStringValue()));
        this.m_SelectedTheme.setStringValue(this.themesMap.get(this.m_SelectedTheme.getStringValue()));
        BufferedDataTable inputTable = inData[0];
        long rowCount = inputTable.size();
        LOGGER.info((Object)("Row count:" + rowCount));
        LOGGER.debug((Object)("Data Table Spec:" + inputTable.getDataTableSpec().toString()));
        ColumnRearranger c = this.createColumnRearranger(inputTable.getDataTableSpec(), rowCount, exec);
        exec.createColumnRearrangeTable(inputTable, c, (ExecutionMonitor)exec);
        return null;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        boolean hasStringColumn = false;
        boolean containsName = false;
        int i = 0;
        while (i < inSpecs[0].getNumColumns()) {
            DataColumnSpec columnSpec = inSpecs[0].getColumnSpec(i);
            if (columnSpec.getType().isCompatible(StringValue.class)) {
                hasStringColumn = true;
            }
            if (this.m_SelectedColumn != null && columnSpec.getName().equals(this.m_SelectedColumn.getStringValue())) {
                containsName = true;
            }
            ++i;
        }
        if (!hasStringColumn) {
            throw new InvalidSettingsException("Input table must contain at least one string column");
        }
        if (!containsName) {
            throw new InvalidSettingsException("Input table does not contain column >>" + this.m_SelectedColumn.getStringValue() + "<<! Please (re-)configure the node.");
        }
        return null;
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec inputTableSpec, final long rowCount, final ExecutionContext exec) throws Exception {
        ColumnRearranger c = new ColumnRearranger(inputTableSpec);
        DataColumnSpecCreator newColSpec = new DataColumnSpecCreator(inputTableSpec.getColumnSpec(0));
        int SelectedColumnIndex = 0;
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            DataColumnSpec columnSpec = inputTableSpec.getColumnSpec(i);
            if (columnSpec.getName().equals(this.m_SelectedColumn.getStringValue())) {
                String newName = String.valueOf(columnSpec.getName()) + "_" + this.m_SelectedBackend.getStringValue().toUpperCase();
                newColSpec = new DataColumnSpecCreator(newName, StringCell.TYPE);
                SelectedColumnIndex = i;
                LOGGER.debug((Object)("Selected column index: " + i));
            }
            ++i;
        }
        final int ColumnIndex = SelectedColumnIndex;
        SingleCellFactory factory = new SingleCellFactory(newColSpec.createSpec()){

            public DataCell getCell(DataRow row) {
                Object value;
                String key;
                exec.setProgress(0.0, "Retreiving input data...");
                LOGGER.debug((Object)"Retrieving input data...");
                DataCell inputCell = row.getCell(ColumnIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                exec.setProgress(0.05, "Creating Asciidoctor configuration...");
                LOGGER.debug((Object)"Creating Asciidoctor configuration...");
                String outputFileTemp = "";
                outputFileTemp = !AsciidoctorJWriterNodeModel.this.m_OutputFile.getStringValue().toUpperCase().endsWith(AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue().toUpperCase()) ? String.valueOf(AsciidoctorJWriterNodeModel.this.m_OutputFile.getStringValue()) + "." + AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue() : AsciidoctorJWriterNodeModel.this.m_OutputFile.getStringValue();
                File outputDir = new File(AsciidoctorJWriterNodeModel.this.m_OutputPath.getStringValue());
                File outputFile = new File(outputFileTemp);
                if (rowCount > 1L) {
                    LOGGER.warn((Object)"More than one row detected. Using RowIDs as filenames!");
                    AsciidoctorJWriterNodeModel.this.setWarningMessage("More than one row detected. Using RowIDs as filenames!");
                    outputFile = new File(row.getKey() + "." + AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue());
                }
                if (AsciidoctorJWriterNodeModel.this.m_OutputFile.getStringValue().equalsIgnoreCase("")) {
                    LOGGER.warn((Object)"No output filename selected. Using RowID as filename!");
                    AsciidoctorJWriterNodeModel.this.setWarningMessage("No output filename selected. Using RowID as filename!");
                    outputFile = new File(row.getKey() + "." + AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue());
                }
                LOGGER.debug((Object)("outputDir: " + outputDir));
                LOGGER.debug((Object)("outputFile: " + outputFile));
                Options opts = null;
                Attributes attrs = null;
                Bundle pluginBundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                LOGGER.debug((Object)("pluginBundle: " + pluginBundle.toString()));
                if (AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue().equalsIgnoreCase("html")) {
                    LOGGER.info((Object)"Converting Asciidoc to HTML...");
                    LOGGER.debug((Object)("HeaderFooter Boolean: " + AsciidoctorJWriterNodeModel.this.m_HeaderFooter.getBooleanValue()));
                    LOGGER.debug((Object)("Custom stylesheet value:" + AsciidoctorJWriterNodeModel.this.m_CustomStylesheet.getStringValue()));
                    if (!AsciidoctorJWriterNodeModel.this.m_CustomStylesheet.getStringValue().equalsIgnoreCase("")) {
                        String string = new File(AsciidoctorJWriterNodeModel.this.m_CustomStylesheet.getStringValue()).getParent();
                        LOGGER.debug((Object)("stylesDirTemp: " + string));
                        String styleSheet = new File(AsciidoctorJWriterNodeModel.this.m_CustomStylesheet.getStringValue()).getName();
                        LOGGER.debug((Object)("filenameTemp: " + styleSheet));
                        if (new File(AsciidoctorJWriterNodeModel.this.m_CustomStylesheet.getStringValue()).exists()) {
                            LOGGER.debug((Object)"External CSS stylesheet found - will be used for conversion!");
                            attrs = Attributes.builder().stylesDir(string).styleSheetName(styleSheet).icons("font").iconFontRemote(true).build();
                        } else {
                            LOGGER.warn((Object)"External CSS stylesheet not found! Converting with default style!");
                            AsciidoctorJWriterNodeModel.this.setWarningMessage("External CSS stylesheet not found! Converting with default style!");
                            attrs = Attributes.builder().icons("font").iconFontRemote(true).build();
                        }
                    } else {
                        Path path = new Path(String.valueOf(File.separator) + "css_stylesheets");
                        Path stylesheetFile = new Path(String.valueOf(File.separator) + "css_stylesheets" + File.separator + AsciidoctorJWriterNodeModel.this.m_SelectedStylesheet.getStringValue());
                        LOGGER.debug((Object)("stylesheetsDir: " + path.toString()));
                        LOGGER.debug((Object)("stylesheetFile: " + stylesheetFile.toString()));
                        LOGGER.debug((Object)"Locating URLs...");
                        URL urlStylesheetsDir = FileLocator.find((Bundle)pluginBundle, (IPath)path, null);
                        URL urlStylesheetFile = FileLocator.find((Bundle)pluginBundle, (IPath)stylesheetFile, null);
                        LOGGER.debug((Object)("urlStylesheetsDir: " + urlStylesheetsDir.toString()));
                        LOGGER.debug((Object)("urlStylesheetFile: " + urlStylesheetFile.toString()));
                        try {
                            URL stylesDir = FileLocator.toFileURL((URL)urlStylesheetsDir);
                            LOGGER.debug((Object)("stylesDir: " + stylesDir));
                            URL styleSheet = FileLocator.toFileURL((URL)urlStylesheetFile);
                            LOGGER.debug((Object)("styleSheet: " + styleSheet));
                            LOGGER.debug((Object)"Internal CSS stylesheet found!");
                            LOGGER.debug((Object)"Creating attributes using internal styles");
                            attrs = Attributes.builder().stylesDir(stylesDir.getPath()).styleSheetName(styleSheet.getPath()).icons("font").iconFontRemote(true).build();
                        }
                        catch (IOException e) {
                            LOGGER.fatal((Object)"Internal CSS stylesheet not found!");
                            LOGGER.fatal((Object)"FileLocator problem: ", (Throwable)e);
                            LOGGER.fatal((Object)"Converting with default AsciidoctorJ stylesheet");
                            attrs = Attributes.builder().icons("font").iconFontRemote(true).build();
                        }
                    }
                    LOGGER.debug((Object)("Using attributes: " + attrs.toString()));
                    LOGGER.debug((Object)"Creating options...");
                    opts = Options.builder().safe(SafeMode.UNSAFE).backend(AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue()).headerFooter(AsciidoctorJWriterNodeModel.this.m_HeaderFooter.getBooleanValue()).toDir(outputDir).toFile(outputFile).attributes(attrs).build();
                    LOGGER.debug((Object)"Finished creating asciidoctor options!");
                    for (Map.Entry entry : opts.map().entrySet()) {
                        key = (String)entry.getKey();
                        value = entry.getValue();
                        LOGGER.debug((Object)("Option " + key.toString() + " set to value: " + value.toString()));
                    }
                }
                if (AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue().equalsIgnoreCase("pdf")) {
                    LOGGER.info((Object)"Converting Asciidoc to PDF...");
                    LOGGER.debug((Object)("Custom theme value:" + AsciidoctorJWriterNodeModel.this.m_CustomTheme.getStringValue()));
                    if (!AsciidoctorJWriterNodeModel.this.m_CustomTheme.getStringValue().equalsIgnoreCase("")) {
                        LOGGER.debug((Object)"Trying to configure external theme...");
                        if (new File(AsciidoctorJWriterNodeModel.this.m_CustomTheme.getStringValue()).exists()) {
                            LOGGER.debug((Object)"External yml theme found - will be used for conversion!");
                            attrs = Attributes.builder().attribute("pdf-style", (Object)AsciidoctorJWriterNodeModel.this.m_CustomTheme.getStringValue()).attribute("icons", (Object)"font").build();
                        } else {
                            LOGGER.warn((Object)"External yml theme not found - Converting with default AsciidoctorJ theme!");
                            AsciidoctorJWriterNodeModel.this.setWarningMessage("External yml theme not found - converting with default AsciidoctorJ theme!");
                            attrs = Attributes.builder().attribute("icons", (Object)"font").build();
                        }
                    } else {
                        LOGGER.debug((Object)"Trying to configure internal theme...");
                        Path path = new Path(String.valueOf(File.separator) + "yml_themes");
                        Path fontsDir = new Path(String.valueOf(File.separator) + "fonts");
                        String themeFileTemp = String.valueOf(AsciidoctorJWriterNodeModel.this.m_SelectedTheme.getStringValue()) + "-theme.yml";
                        Path themeFile = new Path(String.valueOf(File.separator) + "yml_themes" + File.separator + themeFileTemp);
                        LOGGER.debug((Object)("themeDir: " + path.toString()));
                        LOGGER.debug((Object)("themeFileTemp: " + themeFileTemp));
                        LOGGER.debug((Object)("themeFile: " + themeFile.toString()));
                        URL urlThemesDir = FileLocator.find((Bundle)pluginBundle, (IPath)path, null);
                        URL urlFontsDir = FileLocator.find((Bundle)pluginBundle, (IPath)fontsDir, null);
                        URL urlThemeFile = FileLocator.find((Bundle)pluginBundle, (IPath)themeFile, null);
                        LOGGER.debug((Object)("urlThemesDir: " + urlThemesDir.toString()));
                        LOGGER.debug((Object)("urlFontsDir: " + urlFontsDir.toString()));
                        LOGGER.debug((Object)("urlThemeFile: " + urlThemeFile.toString()));
                        try {
                            String finalThemesDir = FileLocator.toFileURL((URL)urlThemesDir).getPath();
                            LOGGER.debug((Object)("finalThemesDir: " + finalThemesDir));
                            String finalFontsDir = FileLocator.toFileURL((URL)urlFontsDir).getPath();
                            LOGGER.debug((Object)("finalFontsDir: " + finalFontsDir));
                            URL finalThemeFile = FileLocator.toFileURL((URL)urlThemeFile);
                            LOGGER.debug((Object)("finalThemeFile: " + finalThemeFile));
                            LOGGER.debug((Object)"Internal yml theme found - will be used for conversion!");
                            attrs = Attributes.builder().attribute("pdf-themesdir", (Object)finalThemesDir).attribute("pdf-fontsdir", (Object)finalFontsDir).attribute("pdf-theme", (Object)themeFileTemp).attribute("icons", (Object)"font").attribute("allow-uri-read", (Object)true).build();
                        }
                        catch (IOException e) {
                            LOGGER.fatal((Object)"Internal yml-theme not found!");
                            LOGGER.fatal((Object)"FileLocator problem: ", (Throwable)e);
                            LOGGER.fatal((Object)"Converting with default AsciidoctorJ theme");
                            AsciidoctorJWriterNodeModel.this.setWarningMessage("Internal yml theme not found - converting with default AsciidoctorJ theme!");
                            attrs = Attributes.builder().attribute("icons", (Object)"font").build();
                        }
                    }
                    LOGGER.debug((Object)"Creating options");
                    opts = Options.builder().safe(SafeMode.UNSAFE).backend(AsciidoctorJWriterNodeModel.this.m_SelectedBackend.getStringValue()).headerFooter(AsciidoctorJWriterNodeModel.this.m_HeaderFooter.getBooleanValue()).toDir(outputDir).toFile(outputFile).attributes(attrs).build();
                    LOGGER.debug((Object)"Finished creating asciidoctor options!");
                    for (Map.Entry entry : opts.map().entrySet()) {
                        key = (String)entry.getKey();
                        value = entry.getValue();
                        LOGGER.debug((Object)("Option " + key.toString() + " set to value: " + value.toString()));
                    }
                }
                LOGGER.debug((Object)"Creating AsciidoctorJ interface...");
                exec.setProgress(0.1, "Creating Asciidoctor interface...");
                System.setProperty("jruby.compat.version", "RUBY1_9");
                System.setProperty("jruby.compile.mode", "OFF");
                AsciidoctorJRuby asciidoctorJRuby = AsciidoctorJRuby.Factory.create(Arrays.asList("uri:classloader:/gems/asciidoctor-2.0.18/lib", "uri:classloader:/gems/asciimath-2.0.4/lib", "uri:classloader:/gems/coderay-1.1.3/lib", "uri:classloader:/gems/concurrent-ruby-1.1.7/lib", "uri:classloader:/gems/erubis-2.7.0/lib", "uri:classloader:/gems/haml-5.2.2/lib", "uri:classloader:/gems/open-uri-cached-0.0.5/lib", "uri:classloader:/gems/rouge-3.30.0/lib", "uri:classloader:/gems/slim-4.1.0/lib", "uri:classloader:/gems/temple-0.8.2/lib", "uri:classloader:/gems/thread_safe-0.3.6-java/lib", "uri:classloader:/gems/tilt-2.0.10/lib", "uri:classloader:/gems/addressable-2.8.0/lib", "uri:classloader:/gems/afm-0.2.2/lib", "uri:classloader:/gems/Ascii85-1.1.0/lib", "uri:classloader:/gems/asciidoctor-pdf-2.3.3/lib", "uri:classloader:/gems/concurrent-ruby-1.1.7/lib", "uri:classloader:/gems/css_parser-1.12.0/lib", "uri:classloader:/gems/hashery-2.1.2/lib", "uri:classloader:/gems/matrix-0.4.2/lib", "uri:classloader:/gems/pdf-core-0.9.0/lib", "uri:classloader:/gems/pdf-reader-2.10.0/lib", "uri:classloader:/gems/polyglot-0.3.5/lib", "uri:classloader:/gems/prawn-2.4.0/lib", "uri:classloader:/gems/prawn-icon-3.0.0/lib", "uri:classloader:/gems/prawn-svg-0.32.0/lib", "uri:classloader:/gems/prawn-table-0.2.2/lib", "uri:classloader:/gems/prawn-templates-0.1.2/lib", "uri:classloader:/gems/public_suffix-4.0.7/lib", "uri:classloader:/gems/rexml-3.2.5/lib", "uri:classloader:/gems/rghost-0.9.7/lib", "uri:classloader:/gems/rouge-3.30.0/lib", "uri:classloader:/gems/ruby-rc4-0.1.5/lib", "uri:classloader:/gems/text-hyphen-1.4.1/lib", "uri:classloader:/gems/thread_safe-0.3.6-java/lib", "uri:classloader:/gems/treetop-1.6.11/lib", "uri:classloader:/gems/ttfunk-1.7.0/lib", "uri:classloader:/gems/asciidoctor-epub3-1.5.1/lib", "uri:classloader:/gems/gepub-1.0.13/lib", "uri:classloader:/gems/mime-types-3.3.1/lib", "uri:classloader:/gems/mime-types-data-3.2021.0225/lib", "uri:classloader:/gems/mini_portile2-2.5.1/lib", "uri:classloader:/gems/nokogiri-1.11.3-java/lib", "uri:classloader:/gems/racc-1.5.2-java/lib", "uri:classloader:/gems/rubyzip-2.3.0/lib"));
                LOGGER.debug((Object)"Finished creating AsciidoctorJ interface...");
                exec.setProgress(0.2, "Converting input...");
                asciidoctorJRuby.convert(inputCell.toString(), opts);
                asciidoctorJRuby.shutdown();
                LOGGER.info((Object)"Successfully finished Asciidoc conversion!");
                return new StringCell("Finished Asciidoc conversion!");
            }
        };
        c.append((CellFactory)factory);
        return c;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_HeaderFooter.saveSettingsTo(settings);
        this.m_SelectedColumn.saveSettingsTo(settings);
        this.m_SelectedBackend.saveSettingsTo(settings);
        this.m_OutputPath.saveSettingsTo(settings);
        this.m_OutputFile.saveSettingsTo(settings);
        this.m_SelectedStylesheet.saveSettingsTo(settings);
        this.m_SelectedTheme.saveSettingsTo(settings);
        this.m_CustomStylesheet.saveSettingsTo(settings);
        this.m_CustomTheme.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_HeaderFooter.loadSettingsFrom(settings);
        this.m_SelectedColumn.loadSettingsFrom(settings);
        this.m_SelectedBackend.loadSettingsFrom(settings);
        this.m_OutputPath.loadSettingsFrom(settings);
        this.m_OutputFile.loadSettingsFrom(settings);
        this.m_SelectedStylesheet.loadSettingsFrom(settings);
        this.m_SelectedTheme.loadSettingsFrom(settings);
        if (licensed) {
            try {
                this.m_CustomStylesheet.loadSettingsFrom(settings);
                this.m_CustomTheme.loadSettingsFrom(settings);
            }
            catch (Exception exception) {
                this.m_CustomStylesheet.setStringValue("");
                this.m_CustomTheme.setStringValue("");
            }
        } else {
            this.m_CustomStylesheet.setStringValue("");
            this.m_CustomTheme.setStringValue("");
        }
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_HeaderFooter.validateSettings(settings);
        this.m_SelectedColumn.validateSettings(settings);
        this.m_SelectedBackend.validateSettings(settings);
        this.m_OutputPath.validateSettings(settings);
        this.m_OutputFile.validateSettings(settings);
        this.m_SelectedStylesheet.validateSettings(settings);
        this.m_SelectedTheme.validateSettings(settings);
        this.m_CustomStylesheet.validateSettings(settings);
        this.m_CustomTheme.validateSettings(settings);
        if (this.m_OutputPath.getStringValue().equalsIgnoreCase("") && this.m_OutputFile.getStringValue().equalsIgnoreCase("")) {
            throw new InvalidSettingsException("Either output path or output file must be set!");
        }
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

