/*
 * Decompiled with CFR 0.152.
 */
package de.paradigmchange.asciidoc;

import de.paradigmchange.asciidoc.AsciidoctorJWriterNodeModel;
import java.util.LinkedHashMap;
import java.util.Map;
import org.knime.core.node.NodeLogger;

final class AsciidoctorSettingsHelpers {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AsciidoctorJWriterNodeModel.class);

    AsciidoctorSettingsHelpers() {
    }

    static Map<String, String> createBackendMap(String node) {
        LinkedHashMap<String, String> backendsMap = new LinkedHashMap<String, String>();
        backendsMap.put("HTML", "html");
        if (node.equalsIgnoreCase("AsciidoctorJWriter")) {
            backendsMap.put("PDF", "pdf");
        }
        return backendsMap;
    }

    static Map<String, String> createAvailableStylesheetsMap(Boolean licensed) {
        LinkedHashMap<String, String> stylesheetsMap = new LinkedHashMap<String, String>();
        stylesheetsMap.put("Asciidoctor Skin", "asciidoctor.css");
        stylesheetsMap.put("Asciidoc Classic Skin", "asciidoc-classic.css");
        stylesheetsMap.put("Dark Skin", "dark.css");
        stylesheetsMap.put("Medium Skin", "medium.css");
        stylesheetsMap.put("Ubuntu Skin", "ubuntu.css");
        licensed.booleanValue();
        return stylesheetsMap;
    }

    static Map<String, String> createAvailableThemesMap(Boolean licensed) {
        LinkedHashMap<String, String> themesMap = new LinkedHashMap<String, String>();
        if (licensed.booleanValue()) {
            LOGGER.debug((Object)"Licensed mode - adding themes without footer");
            themesMap.put("AsciidocNodes Default Theme", "FlatUIv1-print_Base");
            themesMap.put("Asciidoctor Default Theme", "base");
        } else {
            LOGGER.debug((Object)"Unlicensed mode - adding themes with footer");
            themesMap.put("AsciidocNodes Default Theme", "FlatUIv1-print_Base-unlicensed");
            themesMap.put("Asciidoctor Default Theme", "base-unlicensed");
        }
        return themesMap;
    }

    static String[] getMapKeys(Map<String, String> inputMap) {
        return inputMap.keySet().toArray(new String[0]);
    }
}

