/*
 * Decompiled with CFR 0.152.
 */
package de.paradigmchange.asciidoc;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.LicenseManager;
import java.util.Iterator;
import java.util.Map;
import org.knime.core.node.NodeLogger;

public class LicenseChecker {
    public static final String PRODUCT_ID = "de.paradigmchange.asciidoc";
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LicenseChecker.class);
    private static final String SERVER_LICENSE_FEATURE_KEY = "knimeServer";
    private static final String LICENSE_LOG_MESSAGE = "\n******************************************************************************** \n  It looks like this workflow is executed on a KNIME Server, which requires a \n  valid license. In case of questions, please contact mail@paradigmchange.de. \n********************************************************************************";
    private static final byte[] DIGEST = new byte[]{-15, -75, 69, 108, 1, 125, -110, -79, -76, 28, 23, -60, 96, -100, -56, -76, -11, -76, 4, -105, 26, 92, -37, -115, -88, -102, -64, -49, 114, -62, 45, -39, -92, 110, -114, 48, 125, -128, 127, 80, -102, -62, 15, 122, -45, -121, 97, 32, -12, 100, -105, 96, -40, 51, 76, 95, -105, -128, -82, 65, -125, -64, -82, -94};

    public static boolean checkLicense() {
        if (LicenseChecker.isRunningOnKNIMEServer()) {
            LicenseInformation license;
            try {
                license = LicenseManager.getProduct((String)PRODUCT_ID).getLicense();
            }
            catch (LicenseException e) {
                LOGGER.error((Object)LICENSE_LOG_MESSAGE);
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "\nPlease check the console log for more details.");
            }
            if (!license.getBooleanFeature(SERVER_LICENSE_FEATURE_KEY)) {
                LOGGER.error((Object)LICENSE_LOG_MESSAGE);
                throw new IllegalStateException("The specified license is not valid for a KNIME Server environment. \nPlease check the console log for more details.");
            }
        } else {
            try {
                LicenseInformation license = LicenseManager.getProduct((String)PRODUCT_ID).getLicense();
                if (license.daysToExpiration() > 0) {
                    LOGGER.info((Object)"License found for the AsciiDoc nodes");
                    return true;
                }
            }
            catch (LicenseException licenseException) {
                LOGGER.info((Object)"No license found for the AsciiDoc Nodes!");
                return false;
            }
        }
        LOGGER.info((Object)"No license found for the AsciiDoc Nodes!");
        LOGGER.warn((Object)"This code should not have been executed...!");
        return false;
    }

    private static boolean isRunningOnKNIMEServer() {
        String enterpriseApplicationClass = "com.knime.enterprise.executor.KNIMEExecutorApplication";
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Iterator<StackTraceElement[]> iterator = stackTraces.values().iterator();
        while (iterator.hasNext()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = iterator.next();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().startsWith(enterpriseApplicationClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private LicenseChecker() {
    }

    public static final class Helper
    implements LicenseHelper {
        public byte[] getDigest() {
            return DIGEST;
        }
    }
}

