/*
 * Decompiled with CFR 0.152.
 */
package de.paradigmchange.asciidoc;

import de.paradigmchange.asciidoc.AsciidoctorJConverterSettingsModels;
import de.paradigmchange.asciidoc.AsciidoctorSettingsHelpers;
import de.paradigmchange.asciidoc.LicenseChecker;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class AsciidoctorJConverterNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AsciidoctorJConverterNodeModel.class);
    static final String ADD_HEADER_FOOTER = "Header & Footer";
    static final String SELECTED_COLUMN = "Selected column";
    static final String SELECTED_BACKEND = "Selected backend";
    static final String SELECTED_STYLESHEET = "Selected stylesheet";
    private final SettingsModelBoolean m_HeaderFooter = AsciidoctorJConverterSettingsModels.createHeaderFooterModel();
    private final SettingsModelString m_SelectedColumn = AsciidoctorJConverterSettingsModels.createColumnModel();
    private final SettingsModelString m_SelectedBackend = AsciidoctorJConverterSettingsModels.createBackendModel();
    private final SettingsModelString m_SelectedStylesheet = AsciidoctorJConverterSettingsModels.createStyleSheetModel();
    private static boolean licensed = LicenseChecker.checkLicense();
    private Map<String, String> backendsMap = AsciidoctorSettingsHelpers.createBackendMap("AsciidoctorJWriter");
    private Map<String, String> stylesheetsMap = AsciidoctorSettingsHelpers.createAvailableStylesheetsMap(licensed);

    protected AsciidoctorJConverterNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        LOGGER.info((Object)"Starting Asciidoc conversion...");
        LOGGER.debug((Object)"Reconfiguring Backend, Stylesheet and Theme from Dictionary");
        this.m_SelectedBackend.setStringValue(this.backendsMap.get(this.m_SelectedBackend.getStringValue()));
        this.m_SelectedStylesheet.setStringValue(this.stylesheetsMap.get(this.m_SelectedStylesheet.getStringValue()));
        BufferedDataTable inputTable = inData[0];
        ColumnRearranger c = this.createColumnRearranger(inputTable.getDataTableSpec(), exec);
        BufferedDataTable out = exec.createColumnRearrangeTable(inputTable, c, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        boolean hasStringColumn = false;
        boolean containsName = false;
        int i = 0;
        while (i < inSpecs[0].getNumColumns()) {
            DataColumnSpec columnSpec = inSpecs[0].getColumnSpec(i);
            if (columnSpec.getType().isCompatible(StringValue.class)) {
                hasStringColumn = true;
            }
            if (this.m_SelectedColumn != null && columnSpec.getName().equals(this.m_SelectedColumn.getStringValue())) {
                containsName = true;
            }
            ++i;
        }
        if (!hasStringColumn) {
            throw new InvalidSettingsException("Input table must contain at least one string column");
        }
        if (!containsName) {
            throw new InvalidSettingsException("Input table does not contain column >>" + this.m_SelectedColumn.getStringValue() + "<<! Please (re-)configure the node.");
        }
        ColumnRearranger c = this.createColumnRearranger(inSpecs[0], null);
        DataTableSpec result = c.createSpec();
        return new DataTableSpec[]{result};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec inputTableSpec, ExecutionContext exec) {
        ColumnRearranger c = new ColumnRearranger(inputTableSpec);
        DataColumnSpecCreator newColSpec = new DataColumnSpecCreator(inputTableSpec.getColumnSpec(0));
        int SelectedColumnIndex = 0;
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            DataColumnSpec columnSpec = inputTableSpec.getColumnSpec(i);
            if (columnSpec.getName().equals(this.m_SelectedColumn.getStringValue())) {
                String newName = String.valueOf(columnSpec.getName()) + "_" + this.m_SelectedBackend.getStringValue().toUpperCase();
                newColSpec = new DataColumnSpecCreator(newName, StringCell.TYPE);
                SelectedColumnIndex = i;
            }
            ++i;
        }
        final int ColumnIndex = SelectedColumnIndex;
        SingleCellFactory factory = new SingleCellFactory(newColSpec.createSpec()){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(ColumnIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                LOGGER.debug((Object)("HeaderFooter Boolean: " + AsciidoctorJConverterNodeModel.this.m_HeaderFooter.getBooleanValue()));
                LOGGER.debug((Object)("Backend: " + AsciidoctorJConverterNodeModel.this.m_SelectedBackend.getStringValue()));
                File f = new File(AsciidoctorJConverterNodeModel.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                File stylesDir = new File(String.valueOf(f.getPath()) + File.separator + "css_stylesheets");
                File styleSheet = new File(String.valueOf(f.getPath()) + File.separator + "css_stylesheets" + File.separator + AsciidoctorJConverterNodeModel.this.m_SelectedStylesheet.getStringValue());
                LOGGER.debug((Object)("stylesDir: " + stylesDir));
                LOGGER.debug((Object)("styleSheet: " + styleSheet));
                LOGGER.debug((Object)("styleSheetName: " + styleSheet.getPath()));
                LOGGER.debug((Object)"Creating Attributes and Options");
                Attributes attrs = Attributes.builder().stylesDir(stylesDir.getPath()).styleSheetName(styleSheet.getPath()).build();
                LOGGER.debug((Object)("backend: " + AsciidoctorJConverterNodeModel.this.m_SelectedBackend.getStringValue()));
                LOGGER.debug((Object)("HeaderFooter: " + AsciidoctorJConverterNodeModel.this.m_HeaderFooter.getBooleanValue()));
                Options opts = Options.builder().safe(SafeMode.UNSAFE).backend(AsciidoctorJConverterNodeModel.this.m_SelectedBackend.getStringValue()).headerFooter(AsciidoctorJConverterNodeModel.this.m_HeaderFooter.getBooleanValue()).attributes(attrs).build();
                LOGGER.debug((Object)"Creating AsciidoctorJ interface...");
                AsciidoctorJRuby asciidoctor = AsciidoctorJRuby.Factory.create(Arrays.asList("uri:classloader:/gems/asciidoctor-2.0.18/lib", "uri:classloader:/gems/asciimath-2.0.4/lib", "uri:classloader:/gems/coderay-1.1.3/lib", "uri:classloader:/gems/concurrent-ruby-1.1.7/lib", "uri:classloader:/gems/erubis-2.7.0/lib", "uri:classloader:/gems/haml-5.2.2/lib", "uri:classloader:/gems/open-uri-cached-0.0.5/lib", "uri:classloader:/gems/rouge-3.30.0/lib", "uri:classloader:/gems/slim-4.1.0/lib", "uri:classloader:/gems/temple-0.8.2/lib", "uri:classloader:/gems/thread_safe-0.3.6-java/lib", "uri:classloader:/gems/tilt-2.0.10/lib", "uri:classloader:/gems/asciidoctor-epub3-1.5.1/lib", "uri:classloader:/gems/gepub-1.0.13/lib", "uri:classloader:/gems/mime-types-3.3.1/lib", "uri:classloader:/gems/mime-types-data-3.2021.0225/lib", "uri:classloader:/gems/mini_portile2-2.5.1/lib", "uri:classloader:/gems/nokogiri-1.11.3-java/lib", "uri:classloader:/gems/racc-1.5.2-java/lib", "uri:classloader:/gems/rubyzip-2.3.0/lib"));
                LOGGER.debug((Object)"Finished creating AsciidoctorJ interface...");
                System.setProperty("jruby.compat.version", "RUBY1_9");
                System.setProperty("jruby.compile.mode", "OFF");
                String outputValue = asciidoctor.convert(inputCell.toString(), opts);
                asciidoctor.shutdown();
                return new StringCell(outputValue);
            }
        };
        c.append((CellFactory)factory);
        return c;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_HeaderFooter.saveSettingsTo(settings);
        this.m_SelectedColumn.saveSettingsTo(settings);
        this.m_SelectedBackend.saveSettingsTo(settings);
        this.m_SelectedStylesheet.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_HeaderFooter.loadSettingsFrom(settings);
        this.m_SelectedColumn.loadSettingsFrom(settings);
        this.m_SelectedBackend.loadSettingsFrom(settings);
        this.m_SelectedStylesheet.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_HeaderFooter.loadSettingsFrom(settings);
        this.m_SelectedColumn.loadSettingsFrom(settings);
        this.m_SelectedBackend.loadSettingsFrom(settings);
        this.m_SelectedStylesheet.loadSettingsFrom(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

