/*
 * Decompiled with CFR 0.152.
 */
package de.paradigmchange.asciidoc;

import de.paradigmchange.asciidoc.AsciidoctorJWriterNodeModel;
import de.paradigmchange.asciidoc.AsciidoctorJWriterSettingsModels;
import de.paradigmchange.asciidoc.AsciidoctorSettingsHelpers;
import de.paradigmchange.asciidoc.LicenseChecker;
import java.util.Arrays;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.data.StringValue;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class AsciidoctorJWriterNodeDialog
extends DefaultNodeSettingsPane {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AsciidoctorJWriterNodeModel.class);
    private static boolean licensed = LicenseChecker.checkLicense();

    protected AsciidoctorJWriterNodeDialog() {
        Map<String, String> backendsMap = AsciidoctorSettingsHelpers.createBackendMap("AsciidoctorJWriter");
        Map<String, String> stylesheetsMap = AsciidoctorSettingsHelpers.createAvailableStylesheetsMap(licensed);
        Map<String, String> themesMap = AsciidoctorSettingsHelpers.createAvailableThemesMap(licensed);
        final SettingsModelBoolean booleanSettingsHeaderFooter = AsciidoctorJWriterSettingsModels.createHeaderFooterModel();
        SettingsModelString stringSettingsColumn = AsciidoctorJWriterSettingsModels.createColumnModel();
        final SettingsModelString stringSettingsBackend = AsciidoctorJWriterSettingsModels.createBackendModel();
        SettingsModelString stringSettingOutpath = AsciidoctorJWriterSettingsModels.createOutpathModel();
        SettingsModelString stringSettingOutfile = AsciidoctorJWriterSettingsModels.createOutfileModel();
        final SettingsModelString stringSettingsStylesheet = AsciidoctorJWriterSettingsModels.createSelectedStylesheetModel();
        final SettingsModelString stringSettingsTheme = AsciidoctorJWriterSettingsModels.createSelectedThemeModel();
        final SettingsModelString stringSettingCustomStylesheet = AsciidoctorJWriterSettingsModels.createCustomStylesheetModel();
        final SettingsModelString stringSettingCustomTheme = AsciidoctorJWriterSettingsModels.createCustomThemeModel();
        LOGGER.error((Object)("Licensed status - dialog: " + licensed));
        this.createNewGroup("Basic settings");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(stringSettingsColumn, "Select source column: ", 0, true, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(stringSettingsBackend, "Select processing backend: ", Arrays.asList(AsciidoctorSettingsHelpers.getMapKeys(backendsMap))));
        DialogComponentFileChooser pathComponent = new DialogComponentFileChooser(stringSettingOutpath, "OutputFolder", 1, true);
        pathComponent.setBorderTitle("Output folder...");
        this.addDialogComponent((DialogComponent)new DialogComponentString(stringSettingOutfile, "Filename: ", false, 30));
        this.addDialogComponent((DialogComponent)pathComponent);
        this.createNewGroup("Advanced HTML settings");
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(booleanSettingsHeaderFooter, "Add header and footer? "));
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(stringSettingsStylesheet, "Select stylesheet: ", Arrays.asList(AsciidoctorSettingsHelpers.getMapKeys(stylesheetsMap))));
        DialogComponentFileChooser fileComponent1 = new DialogComponentFileChooser(stringSettingCustomStylesheet, "Custom CSS Stylesheet (.css)", 0, false, new String[]{".css"});
        fileComponent1.setBorderTitle("Select custom CSS stylesheet");
        if (licensed) {
            this.addDialogComponent((DialogComponent)fileComponent1);
        } else {
            stringSettingCustomStylesheet.setEnabled(false);
            stringSettingCustomStylesheet.setStringValue("");
        }
        this.createNewGroup("Advanced PDF settings");
        DialogComponentStringSelection themeSettings = new DialogComponentStringSelection(stringSettingsTheme, "Select theme: ", Arrays.asList(AsciidoctorSettingsHelpers.getMapKeys(themesMap)));
        this.addDialogComponent((DialogComponent)themeSettings);
        themeSettings.getComponentPanel().enable(false);
        DialogComponentFileChooser fileComponent2 = new DialogComponentFileChooser(stringSettingCustomTheme, "Custom PDF Theme (.yml)", 0, false, new String[]{".yml"});
        fileComponent2.setBorderTitle("Select custom yml theme");
        stringSettingCustomTheme.setEnabled(false);
        if (licensed) {
            this.addDialogComponent((DialogComponent)fileComponent2);
        } else {
            stringSettingCustomTheme.setEnabled(false);
            stringSettingCustomTheme.setStringValue("");
        }
        stringSettingsBackend.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String switcher;
                LOGGER.debug((Object)"Backend changed");
                LOGGER.error((Object)("Licensed status: " + licensed));
                switch (switcher = stringSettingsBackend.getStringValue().toUpperCase()) {
                    case "PDF": {
                        LOGGER.debug((Object)"Backend pdf");
                        booleanSettingsHeaderFooter.setEnabled(false);
                        stringSettingsStylesheet.setEnabled(false);
                        stringSettingsTheme.setEnabled(true);
                        if (!licensed) break;
                        stringSettingCustomStylesheet.setEnabled(false);
                        stringSettingCustomTheme.setEnabled(true);
                        break;
                    }
                    case "HTML": {
                        LOGGER.debug((Object)"Backend html");
                        stringSettingsTheme.setEnabled(false);
                        booleanSettingsHeaderFooter.setEnabled(true);
                        stringSettingsStylesheet.setEnabled(true);
                        if (!licensed) break;
                        stringSettingCustomStylesheet.setEnabled(true);
                        stringSettingCustomTheme.setEnabled(false);
                        break;
                    }
                    case "XHTML5": {
                        LOGGER.debug((Object)"Backend xhtml5");
                        stringSettingsTheme.setEnabled(false);
                        booleanSettingsHeaderFooter.setEnabled(true);
                        stringSettingsStylesheet.setEnabled(true);
                        if (!licensed) break;
                        stringSettingCustomStylesheet.setEnabled(true);
                        stringSettingCustomTheme.setEnabled(false);
                        break;
                    }
                    case "DOCBOOK": {
                        LOGGER.debug((Object)"Backend docbook");
                        stringSettingsTheme.setEnabled(false);
                        booleanSettingsHeaderFooter.setEnabled(false);
                        stringSettingsStylesheet.setEnabled(false);
                        if (!licensed) break;
                        stringSettingCustomStylesheet.setEnabled(false);
                        stringSettingCustomTheme.setEnabled(false);
                        break;
                    }
                    case "EPUB3": {
                        LOGGER.debug((Object)"Backend epub3");
                        stringSettingsTheme.setEnabled(false);
                        booleanSettingsHeaderFooter.setEnabled(false);
                        stringSettingsStylesheet.setEnabled(false);
                        if (!licensed) break;
                        stringSettingCustomStylesheet.setEnabled(false);
                        stringSettingCustomTheme.setEnabled(false);
                    }
                }
            }
        });
    }
}

