/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.internal.Utils;
import com.verhas.licensor.License;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class LicenseInformation {
    static final String FEATURE_DESCRIPTION = "description";
    private static final String FEATURE_ISSUED = "issued";
    private static final String FEATURE_EXPIRES = "expires";
    private final License license;
    private final String description;
    private final Date issued;
    private final Date expires;

    LicenseInformation(License license, LicenseHelper licenseHelper) throws LicenseException {
        String[] stringArray = new String[]{FEATURE_ISSUED, FEATURE_EXPIRES};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            if (Utils.isEmpty(license.getFeature(feature))) {
                throw new LicenseException(LicenseException.Reason.INCOMPLETE_LICENSE_DATA, String.format("Incomplete license data: Required field `%s` is missing.", feature));
            }
            ++n2;
        }
        this.license = license;
        this.description = licenseHelper.parseDescription(key -> license.getFeature(key));
        if (Utils.isEmpty(this.description)) {
            throw new LicenseException(LicenseException.Reason.INCOMPLETE_LICENSE_DATA, "Incomplete license data: Description is missing.");
        }
        try {
            this.issued = Utils.parseDate(license.getFeature(FEATURE_ISSUED));
            this.expires = Utils.parseDate(license.getFeature(FEATURE_EXPIRES));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LicenseException(LicenseException.Reason.INVALID_LICENSE_DATA, "Invalid license data: Date field could not be parsed.");
        }
        Date today = Utils.getToday();
        if (this.issued.after(today)) {
            throw new LicenseException(LicenseException.Reason.INVALID_LICENSE_DATA, "Invalid license issue date.");
        }
        if (today.after(this.expires)) {
            throw new LicenseException(LicenseException.Reason.LICENSE_EXPIRED, "License has expired on " + Utils.formatDate(this.expires) + ".");
        }
    }

    public String toString() {
        return String.valueOf(this.getDescription()) + " (expires " + Utils.formatDate(this.expires) + ")";
    }

    public int daysToExpiration() {
        long expiresMs = this.expires.getTime() - Utils.getToday().getTime();
        return (int)TimeUnit.MILLISECONDS.toDays(expiresMs);
    }

    public String getDescription() {
        return this.description;
    }

    public Date getIssued() {
        return this.issued;
    }

    public Date getExpires() {
        return this.expires;
    }

    public String getFeature(String key) {
        return this.license.getFeature(Objects.requireNonNull(key));
    }

    public boolean getBooleanFeature(String key) {
        return Boolean.parseBoolean(this.getFeature(key));
    }

    public void requireBooleanFeature(String key) throws LicenseException {
        boolean value = this.getBooleanFeature(key);
        if (!value) {
            throw new LicenseException(LicenseException.Reason.MISSING_FEATURE, String.format("Missing Feature: %s", key));
        }
    }
}

