/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing.nodes;

import com.nodepit.licensing.LicensableProduct;
import com.nodepit.licensing.LicenseManager;
import com.nodepit.licensing.nodes.InputLicenseKeySettings;
import java.awt.Component;
import java.util.Comparator;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentMultiLineString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.util.StringIconOption;

class InputLicenseKeyDialog
extends DefaultNodeSettingsPane {
    private final InputLicenseKeySettings nodeSettings = new InputLicenseKeySettings();

    InputLicenseKeyDialog() {
        StringIconOption[] products = (ProductOption[])LicenseManager.getProducts().stream().map(ProductOption::new).sorted(Comparator.comparing(ProductOption::getHumanReadableText)).toArray(ProductOption[]::new);
        DialogComponentStringSelection productComponent = new DialogComponentStringSelection(this.nodeSettings.productIdentifier, "Product", products);
        JComboBox comboBox = (JComboBox)productComponent.getComponentPanel().getComponent(1);
        comboBox.setRenderer(new ProductOptionRenderer());
        this.addDialogComponent((DialogComponent)productComponent);
        this.addDialogComponent((DialogComponent)new DialogComponentMultiLineString(this.nodeSettings.licenseKey, "License Key", true, 60, 20));
        this.addDialogComponent((DialogComponent)new DialogComponentLabel("Important: Don\u2019t forget to execute the node to set the license key."));
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.validateLicense();
    }

    private static final class ProductOption
    implements StringIconOption {
        private final LicensableProduct product;

        ProductOption(LicensableProduct product) {
            this.product = product;
        }

        public String getText() {
            return this.product.getId();
        }

        public Icon getIcon() {
            return this.product.getIcon();
        }

        public String getHumanReadableText() {
            return Optional.ofNullable(this.product.getBundleName()).orElse(this.product.getId());
        }
    }

    private static final class ProductOptionRenderer
    extends DefaultListCellRenderer {
        private ProductOptionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ProductOption stringIconOption = (ProductOption)value;
            if (stringIconOption != null) {
                this.setText(stringIconOption.getHumanReadableText());
                this.setIcon(stringIconOption.getIcon());
            }
            return component;
        }
    }
}

