/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing.ui;

import com.nodepit.licensing.LicensableProduct;
import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.internal.Activator;
import com.nodepit.licensing.ui.LicenseInputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class LicenseFileFieldEditor
extends FieldEditor {
    private Label licenseLabel;
    private Button changeButton;
    private String rawLicenseString;
    private final LicensableProduct product;

    public LicenseFileFieldEditor(LicensableProduct product, Composite parent) {
        super(product.getId(), "License", parent);
        this.product = product;
        super.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.licenseLabel.getLayoutData();
        gd.horizontalSpan = numColumns - 2;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.licenseLabel = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.licenseLabel.setLayoutData((Object)gd);
        this.changeButton = new Button(parent, 8);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.changeButton, 61);
        gd.widthHint = Math.max(widthHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)gd);
        this.changeButton.setText("Enter...");
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseInputDialog dialog = new LicenseInputDialog(LicenseFileFieldEditor.this.product, LicenseFileFieldEditor.this.getShell());
                int result = dialog.open();
                if (result == 0) {
                    try {
                        String licenseString = dialog.getRawLicenseString();
                        LicenseInformation license = LicenseFileFieldEditor.this.product.parseLicense(licenseString);
                        LicenseFileFieldEditor.this.rawLicenseString = licenseString;
                        LicenseFileFieldEditor.this.setLabel(license.toString(), false);
                    }
                    catch (LicenseException ex) {
                        LicenseFileFieldEditor.this.setLabel(ex.getMessage(), true);
                    }
                }
            }
        });
    }

    private Shell getShell() {
        return this.licenseLabel.getShell();
    }

    protected void setLabel(String label, boolean error) {
        int color = error ? 3 : 2;
        Color colorObject = Display.getCurrent().getSystemColor(color);
        this.licenseLabel.setForeground(colorObject);
        this.licenseLabel.setText(label);
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        if (value.isEmpty()) {
            this.setLabel("No license available.", true);
        } else {
            try {
                LicenseInformation license = this.product.parseLicense(value);
                this.rawLicenseString = value;
                this.setLabel(license.toString(), false);
            }
            catch (LicenseException e) {
                this.setLabel(e.getMessage(), true);
            }
        }
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        this.product.setLicense(this.rawLicenseString);
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setPreferenceStore(IPreferenceStore store) {
    }
}

