/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode;

import me.danielesser.knime.barcode.Activator;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String QRCODE_MONKEY_API_KEY_CFG_KEY = "qrcodeMonkeyApiKey";
    public static final String QRCODE_MONKEY_API_KEY_CFG_DEFAULT = "";

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField(new LinkFieldEditor("For using the QRCode Monkey API, an API key is required. Please enter your key below.\nIn case you do not have an API key yet, follow <a href=\"https://www.qrcode-monkey.com/qr-code-api-with-logo\">these instructions</a> to request one from \nthe developers of QRCode Monkey.", this.getFieldEditorParent(), "https://www.qrcode-monkey.com/qr-code-api-with-logo"));
        this.addField((FieldEditor)new StringFieldEditor(QRCODE_MONKEY_API_KEY_CFG_KEY, "QRCode Monkey API Key", this.getFieldEditorParent()){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                this.getTextControl().setEchoChar('*');
            }
        });
    }

    protected class LinkFieldEditor
    extends FieldEditor {
        private Link m_link;

        protected LinkFieldEditor(String text, Composite parent, final String url) {
            super("linkFieldEditor", PreferencePage.QRCODE_MONKEY_API_KEY_CFG_DEFAULT, parent);
            this.m_link.setText(text);
            this.m_link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)url);
                }
            });
        }

        protected void adjustForNumColumns(int numColumns) {
            Object layout = this.m_link.getLayoutData();
            ((GridData)layout).horizontalSpan = numColumns;
        }

        protected void createControl(Composite parent) {
            this.m_link = new Link(parent, 0);
            super.createControl(parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.m_link.setLayoutData((Object)new GridData(16384, 128, false, false, numColumns, 1));
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

