/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder;

import java.awt.Color;
import me.danielesser.knime.barcode.BarcodeSettings;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelColor;

public class BarcodeEncoderSettings
extends BarcodeSettings {
    private static final String BARCODE_FOREGROUND_COLOR_CFG_KEY = "barcodeForegroundColor";
    private static final String BARCODE_BACKGROUND_COLOR_CFG_KEY = "barcodeBackgroundColor";
    private static final Color BARCODE_FOREGROUND_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final Color BARCODE_BACKGROUND_COLOR_CFG_DEFAULT = Color.WHITE;
    private final SettingsModelColor m_foregroundColor = new SettingsModelColor("barcodeForegroundColor", BARCODE_FOREGROUND_COLOR_CFG_DEFAULT);
    private final SettingsModelColor m_backgroundColor = new SettingsModelColor("barcodeBackgroundColor", BARCODE_BACKGROUND_COLOR_CFG_DEFAULT);

    public SettingsModelColor getForgroundColor() {
        return this.m_foregroundColor;
    }

    public SettingsModelColor getBackgroundColor() {
        return this.m_backgroundColor;
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        super.saveSettingsTo(settings);
        this.m_foregroundColor.saveSettingsTo(settings);
        this.m_backgroundColor.saveSettingsTo(settings);
    }

    @Override
    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        super.loadSettingsFrom(settings);
        this.m_foregroundColor.loadSettingsFrom(settings);
        this.m_backgroundColor.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        super.validateSettings(settings);
        this.m_foregroundColor.validateSettings(settings);
        this.m_backgroundColor.validateSettings(settings);
    }

    @Override
    public void checkSettings(DataTableSpec inSpec) throws InvalidSettingsException {
        super.checkSettings(inSpec);
        int columnIndex = inSpec.findColumnIndex(this.getInputColumn().getStringValue());
        if (!inSpec.getColumnSpec(columnIndex).getType().isCompatible(StringValue.class)) {
            throw new InvalidSettingsException("Input column type must be String.");
        }
    }
}

