/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.codemonkey;

import java.awt.Color;
import java.io.File;
import me.danielesser.knime.barcode.encoder.BarcodeEncoderSettings;
import me.danielesser.knime.barcode.encoder.codemonkey.QRCodeMonkeyCode;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelColor;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class QRCodeMonkeyEncoderSettings
extends BarcodeEncoderSettings {
    public static final String BARCODE_SIZE_CFG_KEY = "barcodeSize";
    public static final String BARCODE_BODY_TYPE_CFG_KEY = "barcodeBodyType";
    public static final String BARCODE_EYE_FRAME_TYPE_CFG_KEY = "barcodeEyeType";
    public static final String BARCODE_EYE_FRAME_1_COLOR_CFG_KEY = "barcodeEye1Color";
    public static final String BARCODE_EYE_FRAME_2_COLOR_CFG_KEY = "barcodeEye2Color";
    public static final String BARCODE_EYE_FRAME_3_COLOR_CFG_KEY = "barcodeEye3Color";
    public static final String BARCODE_EYE_BALL_TYPE_CFG_KEY = "barcodeEyeBallType";
    public static final String BARCODE_EYE_BALL_1_COLOR_CFG_KEY = "barcodeEyeBall1Color";
    public static final String BARCODE_EYE_BALL_2_COLOR_CFG_KEY = "barcodeEyeBall2Color";
    public static final String BARCODE_EYE_BALL_3_COLOR_CFG_KEY = "barcodeEyeBall3Color";
    public static final String BARCODE_LOGO_TYPE_CFG_KEY = "barcodeLogo";
    public static final String BARCODE_LOGO_PATH_CFG_KEY = "barcodeLogoPath";
    private static final int BARCODE_SIZE_CFG_DEFAULT = 200;
    private static final String BARCODE_BODY_TYPE_CFG_DEFAULT = QRCodeMonkeyCode.BodyType.SQUARE.getLabel();
    private static final String BARCODE_EYE_FRAME_TYPE_CFG_DEFAULT = QRCodeMonkeyCode.EyeFrameType.FRAME_0.getLabel();
    private static final Color BARCODE_EYE_FRAME_1_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final Color BARCODE_EYE_FRAME_2_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final Color BARCODE_EYE_FRAME_3_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final String BARCODE_EYE_BALL_TYPE_CFG_DEFAULT = QRCodeMonkeyCode.EyeBallType.BALL_0.getLabel();
    private static final Color BARCODE_EYE_BALL_1_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final Color BARCODE_EYE_BALL_2_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final Color BARCODE_EYE_BALL_3_COLOR_CFG_DEFAULT = Color.BLACK;
    private static final String BARCODE_LOGO_TYPE_CFG_DEFAULT = QRCodeMonkeyCode.LogoType.NO_LOGO.getLabel();
    private static final String BARCODE_LOGO_PATH_CFG_DEFAULT = "";
    private final SettingsModelInteger m_size = new SettingsModelInteger("barcodeSize", 200);
    private final SettingsModelString m_bodyType = new SettingsModelString("barcodeBodyType", BARCODE_BODY_TYPE_CFG_DEFAULT);
    private final SettingsModelString m_eyeFrameType = new SettingsModelString("barcodeEyeType", BARCODE_EYE_FRAME_TYPE_CFG_DEFAULT);
    private final SettingsModelColor m_eyeFrame1Color = new SettingsModelColor("barcodeEye1Color", BARCODE_EYE_FRAME_1_COLOR_CFG_DEFAULT);
    private final SettingsModelColor m_eyeFrame2Color = new SettingsModelColor("barcodeEye2Color", BARCODE_EYE_FRAME_2_COLOR_CFG_DEFAULT);
    private final SettingsModelColor m_eyeFrame3Color = new SettingsModelColor("barcodeEye3Color", BARCODE_EYE_FRAME_3_COLOR_CFG_DEFAULT);
    private final SettingsModelString m_eyeBallType = new SettingsModelString("barcodeEyeBallType", BARCODE_EYE_BALL_TYPE_CFG_DEFAULT);
    private final SettingsModelColor m_eyeBall1Color = new SettingsModelColor("barcodeEyeBall1Color", BARCODE_EYE_BALL_1_COLOR_CFG_DEFAULT);
    private final SettingsModelColor m_eyeBall2Color = new SettingsModelColor("barcodeEyeBall2Color", BARCODE_EYE_BALL_2_COLOR_CFG_DEFAULT);
    private final SettingsModelColor m_eyeBall3Color = new SettingsModelColor("barcodeEyeBall3Color", BARCODE_EYE_BALL_3_COLOR_CFG_DEFAULT);
    private final SettingsModelString m_logoType = new SettingsModelString("barcodeLogo", BARCODE_LOGO_TYPE_CFG_DEFAULT);
    private final SettingsModelString m_logoPath = new SettingsModelString("barcodeLogoPath", "");

    public QRCodeMonkeyEncoderSettings() {
        this.m_logoPath.setEnabled(false);
        this.m_logoType.addChangeListener(e -> this.m_logoPath.setEnabled(this.m_logoType.getStringValue().equals(QRCodeMonkeyCode.LogoType.CUSTOM_LOGO.getLabel())));
    }

    public SettingsModelInteger getSize() {
        return this.m_size;
    }

    public SettingsModelString getBodyType() {
        return this.m_bodyType;
    }

    public SettingsModelString getEyeFrameType() {
        return this.m_eyeFrameType;
    }

    public SettingsModelColor getEyeFrame1Color() {
        return this.m_eyeFrame1Color;
    }

    public SettingsModelColor getEyeFrame2Color() {
        return this.m_eyeFrame2Color;
    }

    public SettingsModelColor getEyeFrame3Color() {
        return this.m_eyeFrame3Color;
    }

    public SettingsModelString getEyeBallType() {
        return this.m_eyeBallType;
    }

    public SettingsModelColor getEyeBall1Color() {
        return this.m_eyeBall1Color;
    }

    public SettingsModelColor getEyeBall2Color() {
        return this.m_eyeBall2Color;
    }

    public SettingsModelColor getEyeBall3Color() {
        return this.m_eyeBall3Color;
    }

    public SettingsModelString getLogoType() {
        return this.m_logoType;
    }

    public SettingsModelString getLogoPath() {
        return this.m_logoPath;
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        super.saveSettingsTo(settings);
        this.m_size.saveSettingsTo(settings);
        this.m_bodyType.saveSettingsTo(settings);
        this.m_eyeFrameType.saveSettingsTo(settings);
        this.m_eyeFrame1Color.saveSettingsTo(settings);
        this.m_eyeFrame2Color.saveSettingsTo(settings);
        this.m_eyeFrame3Color.saveSettingsTo(settings);
        this.m_eyeBallType.saveSettingsTo(settings);
        this.m_eyeBall1Color.saveSettingsTo(settings);
        this.m_eyeBall2Color.saveSettingsTo(settings);
        this.m_eyeBall3Color.saveSettingsTo(settings);
        this.m_logoType.saveSettingsTo(settings);
        this.m_logoPath.saveSettingsTo(settings);
    }

    @Override
    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        super.loadSettingsFrom(settings);
        this.m_size.loadSettingsFrom(settings);
        this.m_bodyType.loadSettingsFrom(settings);
        this.m_eyeFrameType.loadSettingsFrom(settings);
        this.m_eyeFrame1Color.loadSettingsFrom(settings);
        this.m_eyeFrame2Color.loadSettingsFrom(settings);
        this.m_eyeFrame3Color.loadSettingsFrom(settings);
        this.m_eyeBallType.loadSettingsFrom(settings);
        this.m_eyeBall1Color.loadSettingsFrom(settings);
        this.m_eyeBall2Color.loadSettingsFrom(settings);
        this.m_eyeBall3Color.loadSettingsFrom(settings);
        this.m_logoType.loadSettingsFrom(settings);
        this.m_logoPath.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        super.validateSettings(settings);
        this.m_size.validateSettings(settings);
        this.m_bodyType.validateSettings(settings);
        this.m_eyeFrameType.validateSettings(settings);
        this.m_eyeFrame1Color.validateSettings(settings);
        this.m_eyeFrame2Color.validateSettings(settings);
        this.m_eyeFrame3Color.validateSettings(settings);
        this.m_eyeBallType.validateSettings(settings);
        this.m_eyeBall1Color.validateSettings(settings);
        this.m_eyeBall2Color.validateSettings(settings);
        this.m_eyeBall3Color.validateSettings(settings);
        this.m_logoType.validateSettings(settings);
        this.m_logoPath.validateSettings(settings);
    }

    @Override
    public void checkSettings(DataTableSpec inSpec) throws InvalidSettingsException {
        super.checkSettings(inSpec);
        if (this.getBodyType().getStringValue() == null || this.getBodyType().getStringValue().length() == 0) {
            throw new InvalidSettingsException("Body type is not specified.");
        }
        if (this.getEyeFrameType().getStringValue() == null || this.getEyeFrameType().getStringValue().length() == 0) {
            throw new InvalidSettingsException("Eye frame type is not specified.");
        }
        if (this.getEyeBallType().getStringValue() == null || this.getEyeBallType().getStringValue().length() == 0) {
            throw new InvalidSettingsException("Eye ball type is not specified.");
        }
        if (this.getLogoType().getStringValue() == null) {
            throw new InvalidSettingsException("Logo type is not specified.");
        }
        if (this.getSize().getIntValue() <= 0) {
            throw new InvalidSettingsException("Size has to be greater 0.");
        }
        if (this.getLogoType().getStringValue().equals(QRCodeMonkeyCode.LogoType.CUSTOM_LOGO.getLabel())) {
            if (this.getLogoPath().getStringValue() == null || this.getLogoPath().getStringValue().length() == 0) {
                throw new InvalidSettingsException("Logo file for custom logo is not specified.");
            }
            File f = new File(this.getLogoPath().getStringValue());
            if (!f.exists() || f.isDirectory()) {
                throw new InvalidSettingsException("Logo file for custom logo does not exist or is a directory.");
            }
        }
    }
}

