/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZXingCode {
    private String data;
    private int width = 200;
    private int height = 200;
    private BarcodeFormat format = BarcodeFormat.QR_CODE;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;

    public ZXingCode(String data) {
        this.data = data;
    }

    public ZXingCode withWidth(int width) {
        this.width = width;
        return this;
    }

    public ZXingCode withHeight(int height) {
        this.height = height;
        return this;
    }

    public ZXingCode withFormat(BarcodeFormat format) {
        this.format = format;
        return this;
    }

    public ZXingCode withBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ZXingCode withForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    public InputStream fetchAsInputStream() throws IOException, WriterException {
        BitMatrix matrix = new MultiFormatWriter().encode(this.data, this.format, this.width, this.height);
        MatrixToImageConfig config = new MatrixToImageConfig(this.foregroundColor.getRGB(), this.backgroundColor.getRGB());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)baos, (MatrixToImageConfig)config);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public BufferedImage fetchAsBufferedImage() throws IOException, WriterException {
        BitMatrix matrix = new MultiFormatWriter().encode(this.data, this.format, this.width, this.height);
        MatrixToImageConfig config = new MatrixToImageConfig(this.foregroundColor.getRGB(), this.backgroundColor.getRGB());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)baos, (MatrixToImageConfig)config);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix, (MatrixToImageConfig)config);
    }
}

