/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.zxing;

import com.google.zxing.BarcodeFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import me.danielesser.knime.barcode.encoder.zxing.ZXingCode;
import me.danielesser.knime.barcode.encoder.zxing.ZXingEncoderSettings;
import org.eclipse.swt.widgets.Display;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.DataAwareNodeDialogPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponentColorChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;

public class ZXingEncoderNodeDialog
extends DataAwareNodeDialogPane {
    private static final String PREVIEW_IMAGE = "src/resources/preview.png";
    private static final int PREVIEW_HEIGHT = 200;
    private static final int PREVIEW_WIDTH = 200;
    private ZXingEncoderSettings m_settings = new ZXingEncoderSettings();
    private DataTableSpec m_spec;
    private BufferedDataTable m_dataTable;
    private ImagePanel m_previewPanel;
    private DialogComponentColumnNameSelection m_inputColumn = new DialogComponentColumnNameSelection(this.m_settings.getInputColumn(), "Column with contents", 0, new Class[]{StringValue.class});
    private DialogComponentStringSelection m_format = new DialogComponentStringSelection(this.m_settings.getFormat(), "Barcode format", (String[])Arrays.asList(BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.CODABAR, BarcodeFormat.ITF, BarcodeFormat.QR_CODE, BarcodeFormat.DATA_MATRIX, BarcodeFormat.AZTEC, BarcodeFormat.PDF_417).stream().map(t -> t.toString()).toArray(String[]::new));
    private DialogComponentNumber m_width = new DialogComponentNumber((SettingsModelNumber)this.m_settings.getWidth(), "Width in pixels", (Number)1, 5);
    private DialogComponentNumber m_height = new DialogComponentNumber((SettingsModelNumber)this.m_settings.getHeight(), "Height in pixels", (Number)1, 5);
    private DialogComponentColorChooser m_onPixelColor = new DialogComponentColorChooser(this.m_settings.getForgroundColor(), "Foreground", true);
    private DialogComponentColorChooser m_offPixelColor = new DialogComponentColorChooser(this.m_settings.getBackgroundColor(), "Background", true);

    protected ZXingEncoderNodeDialog() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel panelInput = new JPanel(new GridBagLayout());
        panelInput.setBorder(BorderFactory.createTitledBorder("Input:"));
        GridBagConstraints gbcInput = new GridBagConstraints();
        gbcInput.fill = 1;
        gbcInput.gridx = 0;
        gbcInput.gridy = 0;
        panelInput.add((Component)this.m_inputColumn.getComponentPanel(), gbcInput);
        panel.add((Component)panelInput, gbc);
        JPanel panelBody = new JPanel(new GridBagLayout());
        panelBody.setBorder(BorderFactory.createTitledBorder("Body:"));
        GridBagConstraints gbcBody = new GridBagConstraints();
        gbcBody.fill = 1;
        gbcBody.gridx = 0;
        gbcBody.gridy = 0;
        gbcBody.gridwidth = 2;
        panelBody.add((Component)this.m_format.getComponentPanel(), gbcBody);
        gbcBody.gridx = 0;
        gbcBody.gridy = 1;
        gbcBody.gridwidth = 1;
        panelBody.add((Component)this.m_width.getComponentPanel(), gbcBody);
        gbcBody.gridx = 1;
        gbcBody.gridy = 1;
        panelBody.add((Component)this.m_height.getComponentPanel(), gbcBody);
        gbcBody.gridx = 0;
        gbcBody.gridy = 2;
        panelBody.add((Component)this.m_onPixelColor.getComponentPanel(), gbcBody);
        gbcBody.gridx = 1;
        gbcBody.gridy = 2;
        panelBody.add((Component)this.m_offPixelColor.getComponentPanel(), gbcBody);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)panelBody, gbc);
        JPanel panelPreview = new JPanel(new GridBagLayout());
        panelPreview.setBorder(BorderFactory.createTitledBorder("Preview:"));
        GridBagConstraints gbcPreview = new GridBagConstraints();
        gbcPreview.fill = 1;
        gbcPreview.gridx = 0;
        gbcPreview.gridy = 0;
        this.m_previewPanel = new ImagePanel();
        this.m_previewPanel.setPreferredSize(new Dimension(200, 200));
        panelPreview.add((Component)this.m_previewPanel, gbcPreview);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        panel.add((Component)panelPreview, gbc);
        this.addTab("Options", panel);
        this.m_inputColumn.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_format.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_width.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_height.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_onPixelColor.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_offPixelColor.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
    }

    private void updatePreview(final SettingsModel inputColumnModel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String data = "exampleText";
                if (ZXingEncoderNodeDialog.this.m_dataTable != null) {
                    for (DataRow row : ZXingEncoderNodeDialog.this.m_dataTable) {
                        DataCell cell = row.getCell(ZXingEncoderNodeDialog.this.m_spec.findColumnIndex(((SettingsModelString)inputColumnModel).getStringValue()));
                        if (cell.isMissing()) continue;
                        data = ((StringValue)cell).getStringValue();
                        break;
                    }
                }
                final BufferedImage image = ZXingEncoderNodeDialog.this.createBarcode(data);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ZXingEncoderNodeDialog.this.m_previewPanel.setImage(image);
                        (this).ZXingEncoderNodeDialog.this.m_previewPanel.getParent().repaint();
                    }
                });
            }
        }).start();
    }

    private BufferedImage createBarcode(String data) {
        try {
            return new ZXingCode(data).withFormat(BarcodeFormat.valueOf((String)this.m_settings.getFormat().getStringValue())).withWidth(this.m_settings.getWidth().getIntValue()).withHeight(this.m_settings.getHeight().getIntValue()).withForegroundColor(this.m_settings.getForgroundColor().getColorValue()).withBackgroundColor(this.m_settings.getBackgroundColor().getColorValue()).fetchAsBufferedImage();
        }
        catch (Exception exception) {
            try {
                return ImageIO.read(ZXingEncoderNodeDialog.class.getClassLoader().getResource(PREVIEW_IMAGE));
            }
            catch (IOException iOException) {
                BufferedImage image = new BufferedImage(200, 200, 2);
                int[] content = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(content, Color.WHITE.getRGB());
                return image;
            }
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.m_inputColumn.saveSettingsTo(settings);
        this.m_format.saveSettingsTo(settings);
        this.m_width.saveSettingsTo(settings);
        this.m_height.saveSettingsTo(settings);
        this.m_onPixelColor.saveSettingsTo(settings);
        this.m_offPixelColor.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.m_dataTable = null;
        this.m_spec = (DataTableSpec)specs[0];
        this.m_inputColumn.loadSettingsFrom(settings, specs);
        this.m_format.loadSettingsFrom(settings, specs);
        this.m_width.loadSettingsFrom(settings, specs);
        this.m_height.loadSettingsFrom(settings, specs);
        this.m_onPixelColor.loadSettingsFrom(settings, specs);
        this.m_offPixelColor.loadSettingsFrom(settings, specs);
        this.updatePreview(this.m_inputColumn.getModel());
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObject[] input) throws NotConfigurableException {
        this.m_dataTable = (BufferedDataTable)input[0];
        this.m_spec = this.m_dataTable.getDataTableSpec();
        DataTableSpec[] specs = new DataTableSpec[]{this.m_spec};
        this.m_inputColumn.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_format.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_width.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_height.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_onPixelColor.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_offPixelColor.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.updatePreview(this.m_inputColumn.getModel());
    }

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image;

        public void setImage(Image image) {
            this.image = image.getScaledInstance(200, 200, 2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

