/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.zxing;

import com.google.zxing.BarcodeFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.danielesser.knime.barcode.encoder.zxing.ZXingCode;
import me.danielesser.knime.barcode.encoder.zxing.ZXingEncoderSettings;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.image.png.PNGImageContent;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

public class ZXingEncoderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ZXingEncoderNodeModel.class);
    private ZXingEncoderSettings m_settings = new ZXingEncoderSettings();

    protected ZXingEncoderNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ColumnRearranger rearranger = this.createColumnRearranger(inSpecs[0]);
        return new DataTableSpec[]{rearranger.createSpec()};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        ColumnRearranger rearranger = this.createColumnRearranger(inData[0].getDataTableSpec());
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inData[0], rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{outTable};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        this.m_settings.checkSettings(inSpec);
        String columnName = this.m_settings.getInputColumn().getStringValue();
        final int columnIndex = inSpec.findColumnIndex(columnName);
        String newColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)inSpec, (String)(String.valueOf(columnName) + " (encoded)"));
        DataColumnSpec newColumnSpec = new DataColumnSpecCreator(newColumnName, PNGImageContent.TYPE).createSpec();
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)new SingleCellFactory(false, newColumnSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(columnIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                return ZXingEncoderNodeModel.this.getEncodedCell(inputCell);
            }
        });
        return rearranger;
    }

    private DataCell getEncodedCell(DataCell inputCell) {
        try {
            String data = ((StringValue)inputCell).getStringValue();
            InputStream codeStream = new ZXingCode(data).withFormat(BarcodeFormat.valueOf((String)this.m_settings.getFormat().getStringValue())).withWidth(this.m_settings.getWidth().getIntValue()).withHeight(this.m_settings.getHeight().getIntValue()).withForegroundColor(this.m_settings.getForgroundColor().getColorValue()).withBackgroundColor(this.m_settings.getBackgroundColor().getColorValue()).fetchAsInputStream();
            return new PNGImageContent(codeStream).toImageCell();
        }
        catch (Exception e) {
            logger.debug((Object)"error while encoding barcode", (Throwable)e);
            this.setWarningMessage("Whoops. An error has occurred. The output contains missing cells.");
            return DataType.getMissingCell();
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_settings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

