/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.decoder.zxing;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.danielesser.knime.barcode.decoder.zxing.ZXingDecoderSettings;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.image.ImageValue;
import org.knime.core.data.image.png.PNGImageContent;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

public class ZXingDecoderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ZXingDecoderNodeModel.class);
    private ZXingDecoderSettings m_settings = new ZXingDecoderSettings();
    private int m_nrInvalids = 0;

    protected ZXingDecoderNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ColumnRearranger rearranger = this.createColumnRearranger(inSpecs[0]);
        return new DataTableSpec[]{rearranger.createSpec()};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        ColumnRearranger rearranger = this.createColumnRearranger(inData[0].getDataTableSpec());
        this.m_nrInvalids = 0;
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inData[0], rearranger, (ExecutionMonitor)exec);
        if (this.m_nrInvalids > 0) {
            this.setWarningMessage("Some barcodes could not be decoded. The output contains missing values.");
        }
        return new BufferedDataTable[]{outTable};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        this.m_settings.checkSettings(inSpec);
        String columnName = this.m_settings.getInputColumn().getStringValue();
        int columnIndex = inSpec.findColumnIndex(columnName);
        String newColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)inSpec, (String)(String.valueOf(columnName) + " (decoded)"));
        return this.m_settings.getMultipleCodes().getBooleanValue() ? this.createMultiCodeColumnRearranger(inSpec, columnIndex, newColumnName) : this.createSingleCodeColumnRearranger(inSpec, columnIndex, newColumnName);
    }

    private ColumnRearranger createSingleCodeColumnRearranger(DataTableSpec inSpec, final int barcodeColumnIndex, String newColumnName) throws InvalidSettingsException {
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        DataColumnSpec newColumnSpec = new DataColumnSpecCreator(newColumnName, StringCell.TYPE).createSpec();
        rearranger.append((CellFactory)new SingleCellFactory(false, newColumnSpec){

            public DataCell getCell(DataRow row) {
                try {
                    DataCell inputCell = row.getCell(barcodeColumnIndex);
                    if (inputCell.isMissing()) {
                        return DataType.getMissingCell();
                    }
                    ImageValue imageValue = (ImageValue)inputCell;
                    PNGImageContent imageContent = (PNGImageContent)imageValue.getImageContent();
                    BufferedImage image = (BufferedImage)imageContent.getImage();
                    BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
                    Result codeResult = new MultiFormatReader().decode(binaryBitmap);
                    return new StringCell(codeResult.getText());
                }
                catch (NotFoundException e) {
                    logger.debug((Object)"could not decode barcode", (Throwable)e);
                    ++ZXingDecoderNodeModel.this.m_nrInvalids;
                    return DataType.getMissingCell();
                }
            }
        });
        return rearranger;
    }

    private ColumnRearranger createMultiCodeColumnRearranger(DataTableSpec inSpec, final int barcodeColumnIndex, String newColumnName) throws InvalidSettingsException {
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        DataColumnSpec newColumnSpec = new DataColumnSpecCreator(newColumnName, ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec();
        rearranger.append((CellFactory)new SingleCellFactory(false, newColumnSpec){

            public DataCell getCell(DataRow row) {
                try {
                    DataCell inputCell = row.getCell(barcodeColumnIndex);
                    if (inputCell.isMissing()) {
                        return DataType.getMissingCell();
                    }
                    ImageValue imageValue = (ImageValue)inputCell;
                    PNGImageContent imageContent = (PNGImageContent)imageValue.getImageContent();
                    BufferedImage image = (BufferedImage)imageContent.getImage();
                    BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
                    Result[] codeResults = new GenericMultipleBarcodeReader((Reader)new MultiFormatReader()).decodeMultiple(binaryBitmap);
                    List codeResultCells = Arrays.stream(codeResults).map(Result::getText).map(StringCell::new).collect(Collectors.toList());
                    return CollectionCellFactory.createListCell(codeResultCells);
                }
                catch (NotFoundException e) {
                    logger.debug((Object)"could not decode barcode", (Throwable)e);
                    ++ZXingDecoderNodeModel.this.m_nrInvalids;
                    return DataType.getMissingCell();
                }
            }
        });
        return rearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_settings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

