/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.codemonkey;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.json.JSONObject;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.util.DefaultStringIconOption;
import org.knime.core.node.util.StringIconOption;

public class QRCodeMonkeyCode {
    private static final NodeLogger logger = NodeLogger.getLogger(QRCodeMonkeyCode.class);
    private static final String API_URL = "https://qrcode-monkey.p.rapidapi.com/qr/custom";
    private static final String API_URL_UPLOAD = "https://qrcode-monkey.p.rapidapi.com/qr/uploadImage";
    private static final String API_HEADER_CONTENT_TYPE = "application/json";
    private static final String API_HEADER_ACCEPT = "application/json";
    private static final String ICON_FOLDER = "src/resources/qrcodemonkey/";
    private String apiKey;
    private String data;
    private boolean download = false;
    private String file = "png";
    private int size = 200;
    private BodyType bodyType = BodyType.SQUARE;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private EyeFrameType eyeFrameType = EyeFrameType.FRAME_0;
    private Color eyeFrame1Color = Color.BLACK;
    private Color eyeFrame2Color = Color.BLACK;
    private Color eyeFrame3Color = Color.BLACK;
    private EyeBallType eyeBallType = EyeBallType.BALL_0;
    private Color eyeBall1Color = Color.BLACK;
    private Color eyeBall2Color = Color.BLACK;
    private Color eyeBall3Color = Color.BLACK;
    private LogoType logoType = LogoType.NO_LOGO;
    private String logoPath = "";

    public QRCodeMonkeyCode(String apiKey, String data) {
        this.apiKey = apiKey;
        this.data = data;
    }

    public QRCodeMonkeyCode withDownload(boolean download) {
        this.download = download;
        return this;
    }

    public QRCodeMonkeyCode withFile(String file) {
        this.file = file;
        return this;
    }

    public QRCodeMonkeyCode withSize(int size) {
        this.size = size;
        return this;
    }

    public QRCodeMonkeyCode withBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    public QRCodeMonkeyCode withEyeFrameType(EyeFrameType eyeFrameType) {
        this.eyeFrameType = eyeFrameType;
        return this;
    }

    public QRCodeMonkeyCode withEyeBallType(EyeBallType eyeBallType) {
        this.eyeBallType = eyeBallType;
        return this;
    }

    public QRCodeMonkeyCode withBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public QRCodeMonkeyCode withForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    public QRCodeMonkeyCode withEye1Color(Color eye1Color) {
        this.eyeFrame1Color = eye1Color;
        return this;
    }

    public QRCodeMonkeyCode withEye2Color(Color eye2Color) {
        this.eyeFrame2Color = eye2Color;
        return this;
    }

    public QRCodeMonkeyCode withEye3Color(Color eye3Color) {
        this.eyeFrame3Color = eye3Color;
        return this;
    }

    public QRCodeMonkeyCode withEyeBall1Color(Color eyeBall1Color) {
        this.eyeBall1Color = eyeBall1Color;
        return this;
    }

    public QRCodeMonkeyCode withEyeBall2Color(Color eyeBall2Color) {
        this.eyeBall2Color = eyeBall2Color;
        return this;
    }

    public QRCodeMonkeyCode withEyeBall3Color(Color eyeBall3Color) {
        this.eyeBall3Color = eyeBall3Color;
        return this;
    }

    public QRCodeMonkeyCode withLogoType(LogoType logoType) {
        this.logoType = logoType;
        return this;
    }

    public QRCodeMonkeyCode withLogoPath(String logoPath) {
        this.logoPath = logoPath;
        return this;
    }

    public InputStream fetchAsInputStream() throws IllegalStateException, UnirestException, IOException {
        HttpResponse response = Unirest.post((String)API_URL).header("x-rapidapi-key", this.apiKey).header("Content-Type", "application/json").header("Accept", "application/json").body(new JSONObject().put("data", (Object)this.data).put("size", this.size).put("download", this.download).put("file", (Object)this.file).put("config", (Object)new JSONObject().put("body", (Object)this.bodyType.id).put("bodyColor", (Object)this.hex(this.foregroundColor)).put("bgColor", (Object)this.hex(this.backgroundColor)).put("eye", (Object)this.eyeFrameType.id).put("eye1Color", (Object)this.hex(this.eyeFrame1Color)).put("eye2Color", (Object)this.hex(this.eyeFrame2Color)).put("eye3Color", (Object)this.hex(this.eyeFrame3Color)).put("eyeBall", (Object)this.eyeBallType.id).put("eyeBall1Color", (Object)this.hex(this.eyeBall1Color)).put("eyeBall2Color", (Object)this.hex(this.eyeBall2Color)).put("eyeBall3Color", (Object)this.hex(this.eyeBall3Color)).put("logo", (Object)(this.logoType == LogoType.CUSTOM_LOGO ? this.uploadCustomLogo(this.logoPath) : (this.logoType.id.equals("") ? "" : "#" + this.logoType.id)))).toString()).asBinary();
        logger.debug((Object)("qrcode monkey responded with http code: " + response.getStatus()));
        if (response.getStatus() / 100 == 2) {
            return (InputStream)response.getBody();
        }
        if (response.getStatus() == 403) {
            throw new IllegalStateException("QRCode Monkey API key is expired or invalid. Please check your preferences.");
        }
        throw new IllegalStateException("QRCode Monkey seems to be unavailable right now and responded with an error. Please try again later or contact the creator of Barcode Nodes. Error message is: " + response.getStatus() + ": " + response.getStatusText());
    }

    public BufferedImage fetchAsBufferedImage() throws UnirestException, IOException {
        return ImageIO.read(this.fetchAsInputStream());
    }

    private String uploadCustomLogo(String logoFile) throws IllegalStateException, UnirestException {
        File file = new File(logoFile);
        if (!file.exists()) {
            throw new IllegalStateException("File " + logoFile + "does not exist");
        }
        HttpResponse response = Unirest.post((String)API_URL_UPLOAD).header("x-rapidapi-key", this.apiKey).field("file", new File(logoFile)).asJson();
        logger.debug((Object)("qrcode monkey logo upload responded with http code: " + response.getStatus()));
        if (response.getStatus() / 100 != 2) {
            throw new IllegalStateException(String.valueOf(response.getStatus()) + " - " + response.getStatusText());
        }
        return ((JsonNode)response.getBody()).getObject().getString("file");
    }

    private String hex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static ImageIcon getIcon(String fileId) {
        URL iconUrl = QRCodeMonkeyCode.class.getClassLoader().getResource(ICON_FOLDER + fileId + ".png");
        if (iconUrl != null) {
            return new ImageIcon(iconUrl);
        }
        iconUrl = QRCodeMonkeyCode.class.getClassLoader().getResource("src/resources/qrcodemonkey/default.png");
        if (iconUrl != null) {
            return new ImageIcon(iconUrl);
        }
        logger.debug((Object)("predefined icon could not be loaded from hard drive. fileId: " + fileId));
        return null;
    }

    public static enum BodyType {
        SQUARE("square", "Square"),
        MOSAIC("mosaic", "Mosaic"),
        DOT("dot", "Dots"),
        CIRCLE("circle", "Circles"),
        CIRCLE_ZEBRA("circle-zebra", "Zebra (Horizontal)"),
        CIRCLE_ZEBRA_VERTICAL("circle-zebra-vertical", "Zebra (Vertical)"),
        CIRCULAR("circular", "Circular"),
        EDGE_CUT("edge-cut", "Cutted Edges"),
        EDGE_CUT_SMOOTH("edge-cut-smooth", "Cutted Edge (Smooth)"),
        JAPANESE("japnese", "Japanese"),
        LEAF("leaf", "Leafs"),
        POINTED("pointed", "Outwards Pointer"),
        POINTED_EDGE_CUT("pointed-edge-cut", "Outwards Pointer with Cutted Edges"),
        POINTED_IN("pointed-in", "Inwards Pointer"),
        POINTED_IN_SMOOTH("pointed-in-smooth", "Inwards Pointer (Smooth)"),
        POINTED_SMOOTH("pointed-smooth", "Outwards Pointer (Smooth)"),
        ROUND("round", "Outwards Rounded"),
        ROUNDED_IN("rounded-in", "Inwards Rounded"),
        ROUNDED_IN_SMOOTH("rounded-in-smooth", "Inwards Rounded (Smooth)"),
        ROUNDED_POINTED("rounded-pointed", "Spikes"),
        STAR("star", "Stars"),
        DIAMOND("diamond", "Diamonds");

        private String id;
        private String label;
        private Icon icon;

        private BodyType(String id, String label) {
            this.id = id;
            this.label = label;
            this.icon = QRCodeMonkeyCode.getIcon(id);
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static StringIconOption[] getOptions() {
            return (StringIconOption[])Arrays.stream(BodyType.values()).map(l -> new DefaultStringIconOption(l.label, l.icon)).toArray(StringIconOption[]::new);
        }

        public static BodyType asEnumValue(String s) {
            return Arrays.stream(BodyType.values()).filter(v -> v.id.equals(s) || v.label.equals(s)).findFirst().orElse(SQUARE);
        }
    }

    public static enum EyeBallType {
        BALL_0("ball0", "Ball 0"),
        BALL_1("ball1", "Ball 1"),
        BALL_2("ball2", "Ball 2"),
        BALL_3("ball3", "Ball 3"),
        BALL_4("ball4", "Ball 4"),
        BALL_5("ball5", "Ball 5"),
        BALL_6("ball6", "Ball 6"),
        BALL_7("ball7", "Ball 7"),
        BALL_8("ball8", "Ball 8"),
        BALL_9("ball9", "Ball 9"),
        BALL_10("ball10", "Ball 10"),
        BALL_11("ball11", "Ball 11"),
        BALL_12("ball12", "Ball 12"),
        BALL_13("ball13", "Ball 13"),
        BALL_14("ball14", "Ball 14"),
        BALL_15("ball15", "Ball 15"),
        BALL_16("ball16", "Ball 16"),
        BALL_17("ball17", "Ball 17"),
        BALL_18("ball18", "Ball 18"),
        BALL_19("ball19", "Ball 19");

        private String id;
        private String label;
        private Icon icon;

        private EyeBallType(String id, String label) {
            this.id = id;
            this.label = label;
            this.icon = QRCodeMonkeyCode.getIcon(id);
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static StringIconOption[] getOptions() {
            return (StringIconOption[])Arrays.stream(EyeBallType.values()).map(l -> new DefaultStringIconOption(l.label, l.icon)).toArray(StringIconOption[]::new);
        }

        public static EyeBallType asEnumValue(String s) {
            return Arrays.stream(EyeBallType.values()).filter(v -> v.id.equals(s) || v.label.equals(s)).findFirst().orElse(BALL_0);
        }
    }

    public static enum EyeFrameType {
        FRAME_0("frame0", "Frame 0"),
        FRAME_1("frame1", "Frame 1"),
        FRAME_2("frame2", "Frame 2"),
        FRAME_3("frame3", "Frame 3"),
        FRAME_4("frame4", "Frame 4"),
        FRAME_5("frame5", "Frame 5"),
        FRAME_6("frame6", "Frame 6"),
        FRAME_7("frame7", "Frame 7"),
        FRAME_8("frame8", "Frame 8"),
        FRAME_9("frame9", "Frame 9"),
        FRAME_10("frame10", "Frame 10"),
        FRAME_11("frame11", "Frame 11"),
        FRAME_12("frame12", "Frame 12"),
        FRAME_13("frame13", "Frame 13"),
        FRAME_14("frame14", "Frame 14"),
        FRAME_15("frame15", "Frame 15"),
        FRAME_16("frame16", "Frame 16");

        private String id;
        private String label;
        private Icon icon;

        private EyeFrameType(String id, String label) {
            this.id = id;
            this.label = label;
            this.icon = QRCodeMonkeyCode.getIcon(id);
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static StringIconOption[] getOptions() {
            return (StringIconOption[])Arrays.stream(EyeFrameType.values()).map(l -> new DefaultStringIconOption(l.label, l.icon)).toArray(StringIconOption[]::new);
        }

        public static EyeFrameType asEnumValue(String s) {
            return Arrays.stream(EyeFrameType.values()).filter(v -> v.id.equals(s) || v.label.equals(s)).findFirst().orElse(FRAME_0);
        }
    }

    public static enum LogoType {
        NO_LOGO("", "No Logo"),
        CUSTOM_LOGO("custom-logo", "Custom Logo"),
        QR_CODE_MONKEY("qrcodemonkey", "QR Code Monkey"),
        FACEBOOK("facebook", "Facebook"),
        FACEBOOK_CIRCLE("facebook-circle", "Facebook II"),
        TWITTER_CIRCLE("twitter-circle", "Twitter"),
        YOUTUBE("youtube", "Youtube"),
        YOUTUBE_CIRCLE("youtube-circle", "Youtube II"),
        GOOGLEPLUS_CIRCLE("googleplus-circle", "Google+"),
        INSTAGRAM_CIRCLE("instagram-circle", "Instagram"),
        LINKEDIN_CIRCLE("linkedin-circle", "LinkedIn"),
        XING_CIRCLE("xing-circle", "Xing"),
        PINTEREST_CIRCLE("pinterest-circle", "Pinterest"),
        VIMEO_CIRCLE("vimeo-circle", "Vimeo"),
        SOUNDCLOUD_CIRCLE("soundcloud-circle", "SoundCloud"),
        VK_CIRCLE("vk-circle", "VKontakte"),
        WHATSAPP_CIRCLE("whatsapp-circle", "WhatsApp"),
        APPSTORE("appstore", "Appstore"),
        GOOGLE_PLAY("google-play", "Google Play"),
        GMAIL("gmail", "GMail"),
        CALENDAR("calendar", "Calendar"),
        CALENDAR_CIRCLE("calendar-circle", "Calendar (II)"),
        DOCUMENT_CIRCLE("document-circle", "Documents"),
        PHONE_CIRCLE("phone-circle", "Phone"),
        SHARE_CIRCLE("share-circle", "Share"),
        WIFI_CIRCLE("wifi-circle", "Wifi");

        private String id;
        private String label;
        private Icon icon;

        private LogoType(String id, String label) {
            this.id = id;
            this.label = label;
            this.icon = QRCodeMonkeyCode.getIcon(id);
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static StringIconOption[] getOptions() {
            return (StringIconOption[])Arrays.stream(LogoType.values()).map(l -> new DefaultStringIconOption(l.label, l.icon)).toArray(StringIconOption[]::new);
        }

        public static LogoType asEnumValue(String s) {
            return Arrays.stream(LogoType.values()).filter(v -> v.id.equals(s) || v.label.equals(s)).findFirst().orElse(NO_LOGO);
        }
    }
}

