/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.codemonkey;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import me.danielesser.knime.barcode.Activator;
import me.danielesser.knime.barcode.encoder.codemonkey.QRCodeMonkeyCode;
import me.danielesser.knime.barcode.encoder.codemonkey.QRCodeMonkeyEncoderSettings;
import me.danielesser.knime.barcode.encoder.zxing.ZXingEncoderNodeDialog;
import org.eclipse.swt.widgets.Display;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.DataAwareNodeDialogPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponentColorChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.DefaultStringIconOption;
import org.knime.core.node.util.StringIconOption;

public class QRCodeMonkeyEncoderNodeDialog
extends DataAwareNodeDialogPane {
    private static final String PREVIEW_IMAGE = "src/resources/preview.png";
    private static final int PREVIEW_HEIGHT = 200;
    private static final int PREVIEW_WIDTH = 200;
    private QRCodeMonkeyEncoderSettings m_settings = new QRCodeMonkeyEncoderSettings();
    private DataTableSpec m_spec;
    private BufferedDataTable m_dataTable;
    private ImagePanel m_previewPanel;
    private DialogComponentColumnNameSelection m_inputColumn = new DialogComponentColumnNameSelection(this.m_settings.getInputColumn(), "Column with contents", 0, new Class[]{StringValue.class});
    private DialogComponentNumber m_size = new DialogComponentNumber((SettingsModelNumber)this.m_settings.getSize(), "Size in pixels", (Number)1, 5);
    private DialogComponentStringSelection m_bodyType = new DialogComponentStringSelection(this.m_settings.getBodyType(), "QR code style", (StringIconOption[])Arrays.stream(QRCodeMonkeyCode.BodyType.values()).map(l -> new DefaultStringIconOption(l.getLabel(), l.getIcon())).toArray(StringIconOption[]::new));
    private DialogComponentColorChooser m_onPixelColor = new DialogComponentColorChooser(this.m_settings.getForgroundColor(), "Foreground", true);
    private DialogComponentColorChooser m_offPixelColor = new DialogComponentColorChooser(this.m_settings.getBackgroundColor(), "Background", true);
    private DialogComponentStringSelection m_eyeFrameType = new DialogComponentStringSelection(this.m_settings.getEyeFrameType(), "Frame style", (StringIconOption[])Arrays.stream(QRCodeMonkeyCode.EyeFrameType.values()).map(l -> new DefaultStringIconOption(l.getLabel(), l.getIcon())).toArray(StringIconOption[]::new));
    private DialogComponentColorChooser m_eyeFrame1Color = new DialogComponentColorChooser(this.m_settings.getEyeFrame1Color(), "1st marker", true);
    private DialogComponentColorChooser m_eyeFrame2Color = new DialogComponentColorChooser(this.m_settings.getEyeFrame2Color(), "2nd marker", true);
    private DialogComponentColorChooser m_eyeFrame3Color = new DialogComponentColorChooser(this.m_settings.getEyeFrame3Color(), "3rd marker", true);
    private DialogComponentStringSelection m_eyeBallType = new DialogComponentStringSelection(this.m_settings.getEyeBallType(), "Ball style", (StringIconOption[])Arrays.stream(QRCodeMonkeyCode.EyeBallType.values()).map(l -> new DefaultStringIconOption(l.getLabel(), l.getIcon())).toArray(StringIconOption[]::new));
    private DialogComponentColorChooser m_eyeBall1Color = new DialogComponentColorChooser(this.m_settings.getEyeBall1Color(), "1st marker", true);
    private DialogComponentColorChooser m_eyeBall2Color = new DialogComponentColorChooser(this.m_settings.getEyeBall2Color(), "2nd marker", true);
    private DialogComponentColorChooser m_eyeBall3Color = new DialogComponentColorChooser(this.m_settings.getEyeBall3Color(), "3rd marker", true);
    private DialogComponentStringSelection m_logoType = new DialogComponentStringSelection(this.m_settings.getLogoType(), "Logo style", (StringIconOption[])Arrays.stream(QRCodeMonkeyCode.LogoType.values()).map(l -> new DefaultStringIconOption(l.getLabel(), l.getIcon())).toArray(StringIconOption[]::new));
    private DialogComponentFileChooser m_logoPath = new DialogComponentFileChooser(this.m_settings.getLogoPath(), "", new String[]{".png|.jpg|.jpeg"});

    protected QRCodeMonkeyEncoderNodeDialog() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel panelInput = new JPanel(new GridBagLayout());
        panelInput.setBorder(BorderFactory.createTitledBorder("Input:"));
        GridBagConstraints gbcInput = new GridBagConstraints();
        gbcInput.fill = 1;
        gbcInput.gridx = 0;
        gbcInput.gridy = 0;
        gbcInput.anchor = 10;
        panelInput.add((Component)this.m_inputColumn.getComponentPanel(), gbcInput);
        panel.add((Component)panelInput, gbc);
        JPanel panelBody = new JPanel(new GridBagLayout());
        panelBody.setBorder(BorderFactory.createTitledBorder("Body:"));
        GridBagConstraints gbcBody = new GridBagConstraints();
        JPanel panelType = new JPanel(new GridBagLayout());
        GridBagConstraints gbcType = new GridBagConstraints();
        gbcType.fill = 1;
        gbcType.gridx = 0;
        gbcType.gridy = 0;
        panelType.add((Component)this.m_bodyType.getComponentPanel(), gbcType);
        gbcType.gridx = 1;
        gbcType.gridy = 0;
        panelType.add((Component)this.m_size.getComponentPanel(), gbcType);
        gbcBody.fill = 1;
        gbcBody.gridx = 0;
        gbcBody.gridy = 0;
        panelBody.add((Component)panelType, gbcBody);
        JPanel panelColor = new JPanel(new GridBagLayout());
        GridBagConstraints gbcColor = new GridBagConstraints();
        gbcColor.gridx = 0;
        gbcColor.gridy = 1;
        panelColor.add((Component)this.m_onPixelColor.getComponentPanel(), gbcColor);
        gbcColor.gridx = 1;
        gbcColor.gridy = 1;
        panelColor.add((Component)this.m_offPixelColor.getComponentPanel(), gbcColor);
        gbcBody.fill = 1;
        gbcBody.gridx = 0;
        gbcBody.gridy = 1;
        panelBody.add((Component)panelColor, gbcBody);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)panelBody, gbc);
        JPanel panelMarker = new JPanel(new GridBagLayout());
        panelMarker.setBorder(BorderFactory.createTitledBorder("Position Marker:"));
        GridBagConstraints gbcMarker = new GridBagConstraints();
        gbcMarker.fill = 1;
        gbcMarker.gridx = 0;
        gbcMarker.gridy = 0;
        gbcMarker.gridwidth = 3;
        panelMarker.add((Component)this.m_eyeFrameType.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 0;
        gbcMarker.gridy = 1;
        gbcMarker.gridwidth = 1;
        panelMarker.add((Component)this.m_eyeFrame1Color.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 1;
        gbcMarker.gridy = 1;
        panelMarker.add((Component)this.m_eyeFrame2Color.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 2;
        gbcMarker.gridy = 1;
        panelMarker.add((Component)this.m_eyeFrame3Color.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 0;
        gbcMarker.gridy = 2;
        gbcMarker.gridwidth = 3;
        panelMarker.add((Component)this.m_eyeBallType.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 0;
        gbcMarker.gridy = 3;
        gbcMarker.gridwidth = 1;
        panelMarker.add((Component)this.m_eyeBall1Color.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 1;
        gbcMarker.gridy = 3;
        panelMarker.add((Component)this.m_eyeBall2Color.getComponentPanel(), gbcMarker);
        gbcMarker.gridx = 2;
        gbcMarker.gridy = 3;
        panelMarker.add((Component)this.m_eyeBall3Color.getComponentPanel(), gbcMarker);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)panelMarker, gbc);
        JPanel panelLogo = new JPanel(new GridBagLayout());
        panelLogo.setBorder(BorderFactory.createTitledBorder("Logo:"));
        GridBagConstraints gbcLogo = new GridBagConstraints();
        gbcLogo.fill = 1;
        gbcLogo.gridx = 0;
        gbcLogo.gridy = 0;
        this.m_logoPath.setBorderTitle("Path to custom logo:");
        panelLogo.add((Component)this.m_logoType.getComponentPanel(), gbcLogo);
        gbcLogo.gridx = 0;
        gbcLogo.gridy = 1;
        gbcLogo.weightx = 2.0;
        panelLogo.add((Component)this.m_logoPath.getComponentPanel(), gbcLogo);
        gbc.gridx = 0;
        gbc.gridy = 3;
        panel.add((Component)panelLogo, gbc);
        JPanel panelPreview = new JPanel(new GridBagLayout());
        panelPreview.setBorder(BorderFactory.createTitledBorder("Preview:"));
        GridBagConstraints gbcPreview = new GridBagConstraints();
        gbcPreview.fill = 1;
        gbcPreview.gridx = 0;
        gbcPreview.gridy = 0;
        this.m_previewPanel = new ImagePanel();
        this.m_previewPanel.setPreferredSize(new Dimension(200, 200));
        panelPreview.add((Component)this.m_previewPanel, gbcPreview);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        panel.add((Component)panelPreview, gbc);
        this.addTab("Options", panel);
        this.m_inputColumn.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_bodyType.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_size.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_onPixelColor.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_offPixelColor.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeFrameType.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeFrame1Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeFrame2Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeFrame3Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeBallType.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeBall1Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeBall2Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_eyeBall3Color.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_logoType.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
        this.m_logoPath.getModel().addChangeListener(e -> this.updatePreview(this.m_inputColumn.getModel()));
    }

    private void updatePreview(final SettingsModel inputColumnModel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String data = "exampleText";
                if (QRCodeMonkeyEncoderNodeDialog.this.m_dataTable != null) {
                    for (DataRow row : QRCodeMonkeyEncoderNodeDialog.this.m_dataTable) {
                        DataCell cell = row.getCell(QRCodeMonkeyEncoderNodeDialog.this.m_spec.findColumnIndex(((SettingsModelString)inputColumnModel).getStringValue()));
                        if (cell.isMissing()) continue;
                        data = ((StringValue)cell).getStringValue();
                        break;
                    }
                }
                final BufferedImage image = QRCodeMonkeyEncoderNodeDialog.this.createBarcode(data);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).QRCodeMonkeyEncoderNodeDialog.this.m_previewPanel.setImage(image);
                        (this).QRCodeMonkeyEncoderNodeDialog.this.m_previewPanel.getParent().repaint();
                    }
                });
            }
        }).start();
    }

    private BufferedImage createBarcode(String data) {
        try {
            String apiKey = Activator.getDefault().getPreferenceStore().getString("qrcodeMonkeyApiKey");
            return new QRCodeMonkeyCode(apiKey, data).withBodyType(QRCodeMonkeyCode.BodyType.asEnumValue(this.m_settings.getBodyType().getStringValue())).withForegroundColor(this.m_settings.getForgroundColor().getColorValue()).withBackgroundColor(this.m_settings.getBackgroundColor().getColorValue()).withEyeFrameType(QRCodeMonkeyCode.EyeFrameType.asEnumValue(this.m_settings.getEyeFrameType().getStringValue())).withEye1Color(this.m_settings.getEyeFrame1Color().getColorValue()).withEye2Color(this.m_settings.getEyeFrame2Color().getColorValue()).withEye3Color(this.m_settings.getEyeFrame3Color().getColorValue()).withEyeBallType(QRCodeMonkeyCode.EyeBallType.asEnumValue(this.m_settings.getEyeBallType().getStringValue())).withEyeBall1Color(this.m_settings.getEyeBall1Color().getColorValue()).withEyeBall2Color(this.m_settings.getEyeBall2Color().getColorValue()).withEyeBall3Color(this.m_settings.getEyeBall3Color().getColorValue()).withLogoType(QRCodeMonkeyCode.LogoType.asEnumValue(this.m_settings.getLogoType().getStringValue())).withLogoPath(this.m_settings.getLogoPath().getStringValue()).withSize(this.m_settings.getSize().getIntValue()).fetchAsBufferedImage();
        }
        catch (Exception exception) {
            try {
                return ImageIO.read(ZXingEncoderNodeDialog.class.getClassLoader().getResource(PREVIEW_IMAGE));
            }
            catch (IOException iOException) {
                BufferedImage image = new BufferedImage(200, 200, 2);
                int[] content = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(content, Color.WHITE.getRGB());
                return image;
            }
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.m_inputColumn.saveSettingsTo(settings);
        this.m_bodyType.saveSettingsTo(settings);
        this.m_size.saveSettingsTo(settings);
        this.m_onPixelColor.saveSettingsTo(settings);
        this.m_offPixelColor.saveSettingsTo(settings);
        this.m_eyeFrameType.saveSettingsTo(settings);
        this.m_eyeFrame1Color.saveSettingsTo(settings);
        this.m_eyeFrame2Color.saveSettingsTo(settings);
        this.m_eyeFrame3Color.saveSettingsTo(settings);
        this.m_eyeBallType.saveSettingsTo(settings);
        this.m_eyeBall1Color.saveSettingsTo(settings);
        this.m_eyeBall2Color.saveSettingsTo(settings);
        this.m_eyeBall3Color.saveSettingsTo(settings);
        this.m_logoType.saveSettingsTo(settings);
        this.m_logoPath.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.m_dataTable = null;
        this.m_spec = (DataTableSpec)specs[0];
        this.m_inputColumn.loadSettingsFrom(settings, specs);
        this.m_bodyType.loadSettingsFrom(settings, specs);
        this.m_size.loadSettingsFrom(settings, specs);
        this.m_onPixelColor.loadSettingsFrom(settings, specs);
        this.m_offPixelColor.loadSettingsFrom(settings, specs);
        this.m_eyeFrameType.loadSettingsFrom(settings, specs);
        this.m_eyeFrame1Color.loadSettingsFrom(settings, specs);
        this.m_eyeFrame2Color.loadSettingsFrom(settings, specs);
        this.m_eyeFrame3Color.loadSettingsFrom(settings, specs);
        this.m_eyeBallType.loadSettingsFrom(settings, specs);
        this.m_eyeBall1Color.loadSettingsFrom(settings, specs);
        this.m_eyeBall2Color.loadSettingsFrom(settings, specs);
        this.m_eyeBall3Color.loadSettingsFrom(settings, specs);
        this.m_logoType.loadSettingsFrom(settings, specs);
        this.m_logoPath.loadSettingsFrom(settings, specs);
        this.updatePreview(this.m_inputColumn.getModel());
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObject[] input) throws NotConfigurableException {
        this.m_dataTable = (BufferedDataTable)input[0];
        this.m_spec = this.m_dataTable.getDataTableSpec();
        DataTableSpec[] specs = new DataTableSpec[]{this.m_spec};
        this.m_inputColumn.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_bodyType.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_size.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_onPixelColor.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_offPixelColor.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeFrameType.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeFrame1Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeFrame2Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeFrame3Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeBallType.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeBall1Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeBall2Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_eyeBall3Color.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_logoType.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.m_logoPath.loadSettingsFrom(settings, (PortObjectSpec[])specs);
        this.updatePreview(this.m_inputColumn.getModel());
    }

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image;

        public void setImage(Image image) {
            this.image = image.getScaledInstance(200, 200, 2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

