/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.codemonkey;

import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.danielesser.knime.barcode.Activator;
import me.danielesser.knime.barcode.encoder.codemonkey.QRCodeMonkeyCode;
import me.danielesser.knime.barcode.encoder.codemonkey.QRCodeMonkeyEncoderSettings;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.image.png.PNGImageContent;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

public class QRCodeMonkeyEncoderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(QRCodeMonkeyEncoderNodeModel.class);
    private QRCodeMonkeyEncoderSettings m_settings = new QRCodeMonkeyEncoderSettings();

    protected QRCodeMonkeyEncoderNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ColumnRearranger rearranger = this.createColumnRearranger(inSpecs[0]);
        return new DataTableSpec[]{rearranger.createSpec()};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (Activator.getDefault().getPreferenceStore().getString("qrcodeMonkeyApiKey").isEmpty()) {
            logger.debug((Object)"api key is not specified");
            throw new InvalidSettingsException("No API key specified. Please obtain an API key and enter it on the Barcode Nodes preference page.");
        }
        ColumnRearranger rearranger = this.createColumnRearranger(inData[0].getDataTableSpec());
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inData[0], rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{outTable};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        this.m_settings.checkSettings(inSpec);
        String columnName = this.m_settings.getInputColumn().getStringValue();
        final int columnIndex = inSpec.findColumnIndex(columnName);
        String newColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)inSpec, (String)(String.valueOf(columnName) + " (encoded)"));
        DataColumnSpec newColumnSpec = new DataColumnSpecCreator(newColumnName, PNGImageContent.TYPE).createSpec();
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)new SingleCellFactory(false, newColumnSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(columnIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                return QRCodeMonkeyEncoderNodeModel.this.getEncodedCell(inputCell);
            }
        });
        return rearranger;
    }

    private DataCell getEncodedCell(DataCell inputCell) {
        try {
            String apiKey = Activator.getDefault().getPreferenceStore().getString("qrcodeMonkeyApiKey");
            String data = ((StringValue)inputCell).getStringValue();
            InputStream codeStream = new QRCodeMonkeyCode(apiKey, data).withBodyType(QRCodeMonkeyCode.BodyType.asEnumValue(this.m_settings.getBodyType().getStringValue())).withForegroundColor(this.m_settings.getForgroundColor().getColorValue()).withBackgroundColor(this.m_settings.getBackgroundColor().getColorValue()).withEyeFrameType(QRCodeMonkeyCode.EyeFrameType.asEnumValue(this.m_settings.getEyeFrameType().getStringValue())).withEye1Color(this.m_settings.getEyeFrame1Color().getColorValue()).withEye2Color(this.m_settings.getEyeFrame2Color().getColorValue()).withEye3Color(this.m_settings.getEyeFrame3Color().getColorValue()).withEyeBallType(QRCodeMonkeyCode.EyeBallType.asEnumValue(this.m_settings.getEyeBallType().getStringValue())).withEyeBall1Color(this.m_settings.getEyeBall1Color().getColorValue()).withEyeBall2Color(this.m_settings.getEyeBall2Color().getColorValue()).withEyeBall3Color(this.m_settings.getEyeBall3Color().getColorValue()).withLogoType(QRCodeMonkeyCode.LogoType.asEnumValue(this.m_settings.getLogoType().getStringValue())).withLogoPath(this.m_settings.getLogoPath().getStringValue()).withSize(this.m_settings.getSize().getIntValue()).fetchAsInputStream();
            return new PNGImageContent(codeStream).toImageCell();
        }
        catch (IllegalStateException e) {
            logger.debug((Object)"error while requesting QR code", (Throwable)e);
            this.setWarningMessage("QRCode Monkey responded with an error: " + e.getMessage());
            return DataType.getMissingCell();
        }
        catch (UnirestException e) {
            logger.debug((Object)"error while communicating with the remote server", (Throwable)e);
            this.setWarningMessage("QRCode Monkey doesn't seem to be reachable at the moment. Please try again later.");
            return DataType.getMissingCell();
        }
        catch (Exception e) {
            logger.debug((Object)"error while requesting QR code", (Throwable)e);
            this.setWarningMessage("Whoops. An error has occurred. The output contains missing cells.");
            return DataType.getMissingCell();
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_settings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_settings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

