/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.barcode.encoder.zxing;

import com.google.zxing.BarcodeFormat;
import me.danielesser.knime.barcode.encoder.BarcodeEncoderSettings;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class ZXingEncoderSettings
extends BarcodeEncoderSettings {
    private static final String BARCODE_FORMAT_CFG_KEY = "barcodeFormat";
    private static final String BARCODE_WIDTH_CFG_KEY = "barcodeWidth";
    private static final String BARCODE_HEIGHT_CFG_KEY = "barcodeHeight";
    private static final String BARCODE_FORMAT_CFG_DEFAULT = BarcodeFormat.QR_CODE.toString();
    private static final int BARCODE_WIDTH_CFG_DEFAULT = 200;
    private static final int BARCODE_HEIGHT_CFG_DEFAULT = 200;
    private final SettingsModelString m_format = new SettingsModelString("barcodeFormat", BARCODE_FORMAT_CFG_DEFAULT);
    private final SettingsModelInteger m_width = new SettingsModelInteger("barcodeWidth", 200);
    private final SettingsModelInteger m_height = new SettingsModelInteger("barcodeHeight", 200);

    public SettingsModelString getFormat() {
        return this.m_format;
    }

    public SettingsModelInteger getWidth() {
        return this.m_width;
    }

    public SettingsModelInteger getHeight() {
        return this.m_height;
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        super.saveSettingsTo(settings);
        this.m_format.saveSettingsTo(settings);
        this.m_width.saveSettingsTo(settings);
        this.m_height.saveSettingsTo(settings);
    }

    @Override
    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        super.loadSettingsFrom(settings);
        this.m_format.loadSettingsFrom(settings);
        this.m_width.loadSettingsFrom(settings);
        this.m_height.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        super.validateSettings(settings);
        this.m_format.validateSettings(settings);
        this.m_width.validateSettings(settings);
        this.m_height.validateSettings(settings);
    }

    @Override
    public void checkSettings(DataTableSpec inSpec) throws InvalidSettingsException {
        super.checkSettings(inSpec);
        if (this.getFormat().getStringValue() == null || this.getFormat().getStringValue().length() == 0) {
            throw new InvalidSettingsException("Barcode type is not specified.");
        }
        if (this.getWidth().getIntValue() <= 0) {
            throw new InvalidSettingsException("Width has to be greater 0.");
        }
        if (this.getHeight().getIntValue() <= 0) {
            throw new InvalidSettingsException("Height has to be greater 0.");
        }
    }
}

