/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.batch;

import com.nodepit.batch.VersionProvider;
import com.nodepit.batch.converter.CredentialConverter;
import com.nodepit.batch.converter.FileConverter;
import com.nodepit.batch.converter.VariableConverter;
import com.nodepit.batch.converter.WorkflowConverter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.util.StringFormat;
import org.knime.core.node.workflow.Credentials;
import org.knime.core.node.workflow.FlowVariable;
import org.knime.core.node.workflow.UnsupportedWorkflowVersionException;
import org.knime.core.node.workflow.WorkflowLoadHelper;
import org.knime.core.node.workflow.WorkflowManager;
import org.knime.core.node.workflow.WorkflowPersistor;
import org.knime.core.node.workflow.contextv2.AnalyticsPlatformExecutorInfoBuilderFactory;
import org.knime.core.node.workflow.contextv2.WorkflowContextV2;
import org.knime.core.util.KNIMETimer;
import org.knime.core.util.LoadVersion;
import org.knime.core.util.LockFailedException;
import org.knime.core.util.MutableBoolean;
import org.knime.core.util.Version;
import picocli.CommandLine;

@CommandLine.Command(description={"Run your KNIME workflows in headless mode."}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, name="./knime -application com.nodepit.batch.application.NodePitBatchExecutor", exitCodeOnInvalidInput=10, exitCodeOnExecutionException=50, exitCodeListHeading="Exit Codes:%n", exitCodeList={" 0: Workflow was executed successfully.", "10: An error occured due to invalid user input.", "20: An error occured when loading the workflow.", "30: An error occured when executing the workflow.", "40: An error occured when saving the workflow.", "50: An unknown error occured."})
public class NodePitBatchExecutor
implements Callable<Integer> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(NodePitBatchExecutor.class);
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_ERR_USER_INPUT = 10;
    private static final int EXIT_ERR_LOAD = 20;
    private static final int EXIT_ERR_EXECUTION = 30;
    private static final int EXIT_ERR_SAVE = 40;
    private static final int EXIT_ERR_UNKNOWN = 50;
    @CommandLine.Parameters(paramLabel="WORKFLOW", converter={WorkflowConverter.class}, description={"The absolute, relative or URL path to the workflow to be executed. If you reference a KNIME archive (a.k.a. knar), please extend the knar path by providing the path to the workflow within the archive. The syntax of a knar path is as follows: \u201c/path/to/knar/archive.knar!/path/to/workflow/within/archive\u201d"})
    private WorkflowConverter.Workflow workflow;
    @CommandLine.Option(names={"-r", "--reset"}, description={"Reset the workflow and thus its nodes before execution."})
    private boolean reset;
    @CommandLine.Option(names={"-ps", "--preferences"}, converter={FileConverter.class}, paramLabel="<preferences-file>", description={"The absolute, relative or URL path to the preference file to be used. You can export your preferences to a file within KNIME via \u201cFile \u2192 Export Preferences\u2026\u201d."})
    private File preferences;
    @CommandLine.Option(names={"-c", "--credential"}, converter={CredentialConverter.class}, paramLabel="<name[;login[;password]]>", description={"Specify login and password values for your configured workflow credentials. Configure workflow credentials in KNIME by right-clicking on your workflow and selecting \u201dWorkflow Credentials\u2026\u201d. Some nodes (e.g. DB Connector) allow you to select the credentials for authentication."})
    private List<Credentials> credentials = new ArrayList<Credentials>();
    @CommandLine.Option(names={"-v", "--variable"}, converter={VariableConverter.class}, paramLabel="<name;value;type>", description={"Specify a workflow variable for your configured workflow. Type has to be one of 'String', 'int', 'double'. Configure workflow variables in KNIME by right-clicking on your workflow and selecting \u201dWorkflow Variables\u2026\u201d."})
    private List<FlowVariable> variables = new ArrayList<FlowVariable>();
    private boolean save = true;

    public static int run(String ... args) throws Exception {
        return new CommandLine((Object)new NodePitBatchExecutor()).execute(args);
    }

    static int runWithoutSave(String ... args) throws Exception {
        NodePitBatchExecutor batchExecutor = new NodePitBatchExecutor();
        batchExecutor.save = false;
        return new CommandLine((Object)batchExecutor).execute(args);
    }

    @Override
    public Integer call() throws Exception {
        LOGGER.info((Object)"=================== Executing workflow ====================");
        int exitCode = this.runWorkflow();
        if (exitCode != 0) {
            LOGGER.info((Object)"========= Workflow did not execute sucessfully ============");
        } else {
            LOGGER.info((Object)"============= Workflow executed sucessfully ===============");
        }
        return exitCode;
    }

    private int runWorkflow() {
        WorkflowManager wfm;
        if (this.preferences != null) {
            try {
                this.setPreferences(this.preferences);
            }
            catch (FileNotFoundException ex) {
                LOGGER.error((Object)("Error loading the preference file: " + ex.getMessage()));
                return 10;
            }
            catch (CoreException ex) {
                LOGGER.error((Object)("Error applying the preference file: " + ex.getMessage()));
                return 10;
            }
        }
        long t = System.currentTimeMillis();
        try {
            wfm = this.loadWorkflow();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("IO error while loading the workflow: " + ex.getMessage()));
            return 20;
        }
        catch (InvalidSettingsException ex) {
            LOGGER.error((Object)("Encountered invalid settings while loading the workflow: " + ex.getMessage()));
            return 20;
        }
        catch (CanceledExecutionException canceledExecutionException) {
            LOGGER.error((Object)"Workflow loading was canceled by user");
            return 20;
        }
        catch (UnsupportedWorkflowVersionException ex) {
            LOGGER.error((Object)("Unsupported workflow version: " + ex.getMessage()));
            return 20;
        }
        catch (LockFailedException lockFailedException) {
            LOGGER.error((Object)"Workflow is locked by another KNIME instance");
            return 20;
        }
        boolean sucessful = false;
        try {
            try {
                try {
                    sucessful = this.executeWorkflow(wfm);
                }
                catch (CanceledExecutionException canceledExecutionException) {
                    LOGGER.warn((Object)"Workflow execution canceled");
                    long elapsedTimeMillis = System.currentTimeMillis() - t;
                    String niceTime = StringFormat.formatElapsedTime((long)elapsedTimeMillis);
                    String timeString = "Finished in " + niceTime + " (" + elapsedTimeMillis + "ms)";
                    LOGGER.info((Object)("Workflow execution done " + timeString));
                    LOGGER.info((Object)"Status of workflow after execution:");
                    LOGGER.info((Object)"------------------------------------");
                    NodePitBatchExecutor.dumpWorkflowToLog(wfm);
                    LOGGER.info((Object)"------------------------------------");
                    wfm.getParent().removeProject(wfm.getID());
                    return 30;
                }
            }
            finally {
                long elapsedTimeMillis = System.currentTimeMillis() - t;
            }
        }
        finally {
            wfm.getParent().removeProject(wfm.getID());
        }
    }

    private void setPreferences(File preferencesFile) throws FileNotFoundException, CoreException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(preferencesFile));
        IPreferencesService prefService = Platform.getPreferencesService();
        IExportedPreferences prefs = prefService.readPreferences((InputStream)in);
        IPreferenceFilter filter = new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "configuration", "profile"};
            }

            public Map getMapping(String scope) {
                return null;
            }
        };
        prefService.applyPreferences((IEclipsePreferences)prefs, new IPreferenceFilter[]{filter});
    }

    private WorkflowManager loadWorkflow() throws IOException, InvalidSettingsException, CanceledExecutionException, UnsupportedWorkflowVersionException, LockFailedException {
        WorkflowContextV2 context = WorkflowContextV2.builder().withAnalyticsPlatformExecutor(exec -> ((AnalyticsPlatformExecutorInfoBuilderFactory.AnalyticsPlatformExecutorInfoBuilder)exec.withCurrentUserAsUserId().withLocalWorkflowPath(this.workflow.file.toPath())).withBatchMode(true).withMountpoint("DUMMY", Paths.get(this.workflow.mountpoint.getAbsolutePath(), new String[0]))).withLocalLocation().build();
        Map<String, Credentials> credentialsMap = this.credentials.stream().collect(Collectors.toMap(Credentials::getName, cred -> cred));
        NodepitBatchExecutorWorkflowLoadHelper batchLH = new NodepitBatchExecutorWorkflowLoadHelper(credentialsMap, context);
        WorkflowPersistor.WorkflowLoadResult loadResult = WorkflowManager.loadProject((File)this.workflow.file, (ExecutionMonitor)new ExecutionMonitor(), (WorkflowLoadHelper)batchLH);
        WorkflowManager wfm = loadResult.getWorkflowManager();
        if (!this.variables.isEmpty()) {
            wfm.addWorkflowVariables(!this.reset, (FlowVariable[])this.variables.stream().map(v -> {
                LOGGER.info((Object)("Setting variable " + String.valueOf(v)));
                return v;
            }).toArray(FlowVariable[]::new));
        }
        if (this.reset) {
            wfm.resetAndConfigureAll();
            LOGGER.info((Object)"Workflow reset done.");
        }
        return wfm;
    }

    private boolean executeWorkflow(final WorkflowManager wfm) throws CanceledExecutionException {
        LOGGER.info((Object)"Status of workflow before execution:");
        LOGGER.info((Object)"------------------------------------");
        NodePitBatchExecutor.dumpWorkflowToLog(wfm);
        LOGGER.info((Object)"------------------------------------");
        boolean successful = true;
        final MutableBoolean executionCanceled = new MutableBoolean(false);
        File wsFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        final File cancelFile = new File(wsFile, ".cancel");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (cancelFile.exists()) {
                    wfm.cancelExecution();
                    cancelFile.delete();
                    executionCanceled.setValue(true);
                    this.cancel();
                }
            }
        };
        KNIMETimer.getInstance().schedule(task, 1000L, 1000L);
        successful = wfm.executeAllAndWaitUntilDone();
        task.cancel();
        if (executionCanceled.booleanValue()) {
            throw new CanceledExecutionException();
        }
        return successful;
    }

    private static void dumpWorkflowToLog(WorkflowManager wfm) {
        String str = wfm.printNodeSummary(wfm.getID(), 0);
        BufferedReader reader = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info((Object)line);
            }
            reader.close();
        }
        catch (IOException e) {
            LOGGER.fatal((Object)"IOException while reading string", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$0(File f) {
        return !f.getName().equals(".knimeLock");
    }

    private static final class NodepitBatchExecutorWorkflowLoadHelper
    extends WorkflowLoadHelper {
        private final Map<String, Credentials> m_credentialMap;
        private final WorkflowContextV2 m_workflowContext;

        private NodepitBatchExecutorWorkflowLoadHelper(Map<String, Credentials> credentialMap, WorkflowContextV2 context) {
            this.m_credentialMap = credentialMap;
            this.m_workflowContext = context;
        }

        public List<Credentials> loadCredentials(List<Credentials> credentials) {
            ArrayList<Credentials> newCredentials = new ArrayList<Credentials>();
            for (Credentials cred : credentials) {
                Credentials currCred;
                String login = null;
                String password = null;
                if (this.m_credentialMap.containsKey(cred.getName()) && (currCred = this.m_credentialMap.get(cred.getName())) != null) {
                    login = currCred.getLogin();
                    password = currCred.getPassword();
                }
                LOGGER.info((Object)("Setting credential \"" + cred.getName() + "\""));
                newCredentials.add(new Credentials(cred.getName(), login, password));
            }
            return newCredentials;
        }

        public WorkflowContextV2 getWorkflowContext() {
            return this.m_workflowContext;
        }

        public WorkflowLoadHelper.UnknownKNIMEVersionLoadPolicy getUnknownKNIMEVersionLoadPolicy(LoadVersion workflowKNIMEVersion, Version createdByKNIMEVersion, boolean isNightlyBuild) {
            return WorkflowLoadHelper.UnknownKNIMEVersionLoadPolicy.Try;
        }
    }
}

