/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.batch.converter;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.knime.core.node.workflow.BatchExecutor;
import org.knime.core.node.workflow.FlowVariable;
import org.knime.core.util.tokenizer.Tokenizer;
import org.knime.core.util.tokenizer.TokenizerSettings;
import picocli.CommandLine;

public class VariableConverter
implements CommandLine.ITypeConverter<FlowVariable> {
    public FlowVariable convert(String value) throws Exception {
        try {
            String[] split = VariableConverter.splitWorkflowVariableArg(value);
            return VariableConverter.createWorkflowVariable(split);
        }
        catch (Exception e) {
            throw new CommandLine.TypeConversionException("Invalid value for option '--variable': " + e.getMessage());
        }
    }

    private static String[] splitWorkflowVariableArg(String arg) {
        String token;
        Tokenizer tokenizer = new Tokenizer((Reader)new StringReader(arg));
        TokenizerSettings settings = new TokenizerSettings();
        settings.addQuotePattern("\"", "\"", '\\');
        settings.addQuotePattern("'", "'", '\\');
        settings.addDelimiterPattern(";", false, false, false);
        tokenizer.setSettings(settings);
        ArrayList<String> tokenList = new ArrayList<String>();
        while ((token = tokenizer.nextToken()) != null) {
            tokenList.add(token);
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }

    private static FlowVariable createWorkflowVariable(String[] args) throws BatchExecutor.IllegalOptionException {
        if (args.length != 3) {
            throw new IndexOutOfBoundsException("Invalid format: please speficy name, value and type");
        }
        String name = args[0];
        String value = args[1];
        String type = args[2];
        if ("String".equalsIgnoreCase(type)) {
            return new FlowVariable(name, value);
        }
        if ("int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
            return new FlowVariable(name, Integer.parseInt(value));
        }
        if ("double".equalsIgnoreCase(type)) {
            return new FlowVariable(name, Double.parseDouble(value));
        }
        throw new BatchExecutor.IllegalOptionException("Invalid format: type must be 'String', 'int' or 'double', but was '" + type + "'");
    }
}

