/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.batch.converter;

import com.nodepit.batch.FilenameUtils;
import com.nodepit.batch.converter.FileConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.knime.core.util.FileUtil;
import picocli.CommandLine;

public class WorkflowConverter
implements CommandLine.ITypeConverter<Workflow> {
    private FileConverter fileConverter = new FileConverter();

    public Workflow convert(String value) throws Exception {
        String filePath = value;
        String archivePath = "";
        Pattern pattern = Pattern.compile("^(.*?(\\.knar|\\.knwf|$))!?(.*)");
        Matcher m = pattern.matcher(value);
        if (m.find()) {
            filePath = m.group(1);
            archivePath = m.group(3);
        }
        File inputFile = this.fileConverter.convert(filePath);
        File zipFolder = null;
        boolean deleteFile = false;
        File file = inputFile.getAbsoluteFile();
        File mountpoint = file.getParentFile();
        if (file.isFile()) {
            File tmpDir = FileUtil.createTempDir((String)"NodePitBatchExecutorInput");
            FileUtil.unzip((File)file, (File)tmpDir);
            if (!new File(tmpDir, "workflow.knime").exists()) {
                File[] children = tmpDir.listFiles();
                if (children.length == 0) {
                    throw new IOException("No workflow directory at " + String.valueOf(tmpDir));
                }
                tmpDir = tmpDir.listFiles()[0];
            }
            file = new File(file.getParentFile(), FilenameUtils.removeExtension(file.getName()));
            FileUtil.copyDir((File)tmpDir, (File)file);
            zipFolder = file.getAbsoluteFile();
            deleteFile = true;
        }
        if (archivePath != null && !archivePath.isEmpty()) {
            mountpoint = file;
            if (!(file = new File(file.getAbsolutePath(), archivePath)).exists()) {
                throw new FileNotFoundException("File '" + file.getAbsolutePath() + "' does not exist");
            }
        }
        Workflow workflow = new Workflow();
        workflow.file = file;
        workflow.mountpoint = mountpoint;
        workflow.inputFile = inputFile;
        workflow.zipFolder = zipFolder;
        workflow.deleteFile = deleteFile;
        return workflow;
    }

    public static class Workflow {
        public File file;
        public File mountpoint;
        public File inputFile;
        public File zipFolder;
        public boolean deleteFile;
    }
}

