/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.batch.converter;

import com.nodepit.batch.FilenameUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import picocli.CommandLine;

public class FileConverter
implements CommandLine.ITypeConverter<File> {
    public File convert(String value) throws Exception {
        if (value.startsWith("http://") || value.startsWith("https://")) {
            try {
                URL url = new URL(value);
                Path dir = Files.createTempDirectory("nodepitbatch", new FileAttribute[0]);
                String fileName = FilenameUtils.getName(url.getPath());
                if (fileName == null || fileName.length() < 1) {
                    fileName = "workflow";
                }
                File file = new File(dir.toFile(), fileName);
                URLConnection urlConnection = url.openConnection();
                Throwable throwable = null;
                Object var8_11 = null;
                try (InputStream inputStream = urlConnection.getInputStream();){
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                file.deleteOnExit();
                return file;
            }
            catch (IOException e) {
                throw new CommandLine.TypeConversionException("Could not retrieve URL: " + e.toString());
            }
        }
        File file = new File(value);
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        return file;
    }
}

