/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.createattribute;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import com.nodepit.nodes.brevo.v3.Utils;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CreateAttributeNodeSettings {
    static final String[] ATTRIBUTE_CATEGORY_VALUES = new String[]{"normal", "transactional", "category", "calculated", "global"};
    private static final String ATTRIBUTE_CATEGORY_KEY = "attributeCategory";
    private static final String ATTRIBUTE_CATEGORY_DEFAULT_VALUE = ATTRIBUTE_CATEGORY_VALUES[0];
    private String attributeCategory = ATTRIBUTE_CATEGORY_DEFAULT_VALUE;
    private static final String ATTRIBUTE_NAME_KEY = "attributeName";
    private static final String ATTRIBUTE_NAME_DEFAULT_VALUE = null;
    private String attributeName = ATTRIBUTE_NAME_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateAttributeNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CreateAttributeNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ATTRIBUTE_CATEGORY_KEY, this.attributeCategory);
        settings.addString(ATTRIBUTE_NAME_KEY, this.attributeName);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.attributeCategory = settings.getString(ATTRIBUTE_CATEGORY_KEY, ATTRIBUTE_CATEGORY_DEFAULT_VALUE);
        this.attributeName = settings.getString(ATTRIBUTE_NAME_KEY, ATTRIBUTE_NAME_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.attributeCategory == null || this.attributeCategory.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cAttribute Category\u201d is required.");
        }
        if (this.attributeName == null || this.attributeName.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cAttribute Name\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String attributeCategory() {
        return this.attributeCategory;
    }

    void attributeCategory(String value) {
        this.attributeCategory = value;
    }

    String attributeName() {
        return this.attributeName;
    }

    void attributeName(String value) {
        this.attributeName = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

