/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.deletefolder;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class DeleteFolderNodeSettings {
    private static final String FOLDER_ID_KEY = "folderId";
    static final Integer FOLDER_ID_DEFAULT_VALUE = 0;
    static final Integer FOLDER_ID_MINIMUM_VALUE = null;
    static final Integer FOLDER_ID_MAXIMUM_VALUE = null;
    private int folderId = FOLDER_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    DeleteFolderNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(FOLDER_ID_KEY, this.folderId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.folderId = settings.getInt(FOLDER_ID_KEY, FOLDER_ID_DEFAULT_VALUE.intValue());
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int folderId() {
        return this.folderId;
    }

    void folderId(int value) {
        this.folderId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

