/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getcontactinfo;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetContactInfoNodeSettings {
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String IDENTIFIER_DEFAULT_VALUE = null;
    private String identifier = IDENTIFIER_DEFAULT_VALUE;
    private static final String START_DATE_KEY = "startDate";
    private static final String START_DATE_DEFAULT_VALUE = null;
    private String startDate = START_DATE_DEFAULT_VALUE;
    private static final String START_DATE_ENABLED_KEY = "startDateEnabled";
    private boolean startDateEnabled = false;
    private static final String END_DATE_KEY = "endDate";
    private static final String END_DATE_DEFAULT_VALUE = null;
    private String endDate = END_DATE_DEFAULT_VALUE;
    private static final String END_DATE_ENABLED_KEY = "endDateEnabled";
    private boolean endDateEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetContactInfoNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(IDENTIFIER_KEY, this.identifier);
        settings.addString(START_DATE_KEY, this.startDate);
        settings.addBoolean(START_DATE_ENABLED_KEY, this.startDateEnabled);
        settings.addString(END_DATE_KEY, this.endDate);
        settings.addBoolean(END_DATE_ENABLED_KEY, this.endDateEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.identifier = settings.getString(IDENTIFIER_KEY, IDENTIFIER_DEFAULT_VALUE);
        this.startDate = settings.getString(START_DATE_KEY, START_DATE_DEFAULT_VALUE);
        this.startDateEnabled = settings.getBoolean(START_DATE_ENABLED_KEY, false);
        this.endDate = settings.getString(END_DATE_KEY, END_DATE_DEFAULT_VALUE);
        this.endDateEnabled = settings.getBoolean(END_DATE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String identifier() {
        return this.identifier;
    }

    void identifier(String value) {
        this.identifier = value;
    }

    String startDate() {
        return this.startDate;
    }

    void startDate(String value) {
        this.startDate = value;
    }

    boolean startDateEnabled() {
        return this.startDateEnabled;
    }

    void startDateEnabled(boolean value) {
        this.startDateEnabled = value;
    }

    String endDate() {
        return this.endDate;
    }

    void endDate(String value) {
        this.endDate = value;
    }

    boolean endDateEnabled() {
        return this.endDateEnabled;
    }

    void endDateEnabled(boolean value) {
        this.endDateEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

