/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getinboundemailattachment;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetInboundEmailAttachmentNodeSettings {
    private static final String DOWNLOAD_TOKEN_KEY = "downloadToken";
    private static final String DOWNLOAD_TOKEN_DEFAULT_VALUE = null;
    private String downloadToken = DOWNLOAD_TOKEN_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("Content-Type", StringCell.StringCellFactory.TYPE).createSpec()).addHeaderColumn(new DataColumnSpecCreator("Content-Disposition", StringCell.StringCellFactory.TYPE).createSpec()).addHeaderColumn(new DataColumnSpecCreator("Content-Length", LongCell.LongCellFactory.TYPE).createSpec()).build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetInboundEmailAttachmentNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(DOWNLOAD_TOKEN_KEY, this.downloadToken);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.downloadToken = settings.getString(DOWNLOAD_TOKEN_KEY, DOWNLOAD_TOKEN_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.downloadToken == null || this.downloadToken.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDownload Token\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String downloadToken() {
        return this.downloadToken;
    }

    void downloadToken(String value) {
        this.downloadToken = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

