/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.postcrmdealsimport;

import com.nodepit.nodes.brevo.v3.FilePicker;
import com.nodepit.nodes.brevo.v3.LabelButton;
import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.operation.postcrmdealsimport.PostCrmDealsImportNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class PostCrmDealsImportNodeDialog
extends NodeDialogPane {
    private final PostCrmDealsImportNodeSettings nodeSettings = new PostCrmDealsImportNodeSettings();
    private FilePicker file;
    private JCheckBox fileEnabled;
    private JTextField mapping;
    private JCheckBox mappingEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    PostCrmDealsImportNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.fileEnabled = new JCheckBox();
        this.fileEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.fileEnabled.setSelected(!this.fileEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.fileEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.file = new FilePicker();
        panel.add((Component)this.file, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Mapping:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.mappingEnabled = new JCheckBox();
        this.mappingEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.mappingEnabled.setSelected(!this.mappingEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.mappingEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.mapping = new JTextField(30);
        panel.add((Component)this.mapping, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(PostCrmDealsImportNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.file.setEnabled(this.fileEnabled.isSelected());
        this.mapping.setEnabled(this.mappingEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.file(this.file.getFile());
        this.nodeSettings.fileEnabled(this.fileEnabled.isSelected());
        this.nodeSettings.mapping(this.mapping.getText());
        this.nodeSettings.mappingEnabled(this.mappingEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.file.setFile(this.nodeSettings.file());
        this.fileEnabled.setSelected(this.nodeSettings.fileEnabled());
        this.mapping.setText(this.nodeSettings.mapping());
        this.mappingEnabled.setSelected(this.nodeSettings.mappingEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

