/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.postcrmdealsimport;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class PostCrmDealsImportNodeSettings {
    private static final String FILE_KEY = "file";
    private static final String FILE_DEFAULT_VALUE = null;
    private String file = FILE_DEFAULT_VALUE;
    private static final String FILE_ENABLED_KEY = "fileEnabled";
    private boolean fileEnabled = false;
    private static final String MAPPING_KEY = "mapping";
    private static final String MAPPING_DEFAULT_VALUE = null;
    private String mapping = MAPPING_DEFAULT_VALUE;
    private static final String MAPPING_ENABLED_KEY = "mappingEnabled";
    private boolean mappingEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    PostCrmDealsImportNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_KEY, this.file);
        settings.addBoolean(FILE_ENABLED_KEY, this.fileEnabled);
        settings.addString(MAPPING_KEY, this.mapping);
        settings.addBoolean(MAPPING_ENABLED_KEY, this.mappingEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.file = settings.getString(FILE_KEY, FILE_DEFAULT_VALUE);
        this.fileEnabled = settings.getBoolean(FILE_ENABLED_KEY, false);
        this.mapping = settings.getString(MAPPING_KEY, MAPPING_DEFAULT_VALUE);
        this.mappingEnabled = settings.getBoolean(MAPPING_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String file() {
        return this.file;
    }

    void file(String value) {
        this.file = value;
    }

    boolean fileEnabled() {
        return this.fileEnabled;
    }

    void fileEnabled(boolean value) {
        this.fileEnabled = value;
    }

    String mapping() {
        return this.mapping;
    }

    void mapping(String value) {
        this.mapping = value;
    }

    boolean mappingEnabled() {
        return this.mappingEnabled;
    }

    void mappingEnabled(boolean value) {
        this.mappingEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

