/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.postcrmfiles;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class PostCrmFilesNodeSettings {
    private static final String FILE_KEY = "file";
    private static final String FILE_DEFAULT_VALUE = null;
    private String file = FILE_DEFAULT_VALUE;
    private static final String DEAL_ID_KEY = "dealId";
    private static final String DEAL_ID_DEFAULT_VALUE = null;
    private String dealId = DEAL_ID_DEFAULT_VALUE;
    private static final String DEAL_ID_ENABLED_KEY = "dealIdEnabled";
    private boolean dealIdEnabled = false;
    private static final String CONTACT_ID_KEY = "contactId";
    static final Integer CONTACT_ID_DEFAULT_VALUE = 0;
    static final Integer CONTACT_ID_MINIMUM_VALUE = null;
    static final Integer CONTACT_ID_MAXIMUM_VALUE = null;
    private int contactId = CONTACT_ID_DEFAULT_VALUE;
    private static final String CONTACT_ID_ENABLED_KEY = "contactIdEnabled";
    private boolean contactIdEnabled = false;
    private static final String COMPANY_ID_KEY = "companyId";
    private static final String COMPANY_ID_DEFAULT_VALUE = null;
    private String companyId = COMPANY_ID_DEFAULT_VALUE;
    private static final String COMPANY_ID_ENABLED_KEY = "companyIdEnabled";
    private boolean companyIdEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    PostCrmFilesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_KEY, this.file);
        settings.addString(DEAL_ID_KEY, this.dealId);
        settings.addBoolean(DEAL_ID_ENABLED_KEY, this.dealIdEnabled);
        settings.addInt(CONTACT_ID_KEY, this.contactId);
        settings.addBoolean(CONTACT_ID_ENABLED_KEY, this.contactIdEnabled);
        settings.addString(COMPANY_ID_KEY, this.companyId);
        settings.addBoolean(COMPANY_ID_ENABLED_KEY, this.companyIdEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.file = settings.getString(FILE_KEY, FILE_DEFAULT_VALUE);
        this.dealId = settings.getString(DEAL_ID_KEY, DEAL_ID_DEFAULT_VALUE);
        this.dealIdEnabled = settings.getBoolean(DEAL_ID_ENABLED_KEY, false);
        this.contactId = settings.getInt(CONTACT_ID_KEY, CONTACT_ID_DEFAULT_VALUE.intValue());
        this.contactIdEnabled = settings.getBoolean(CONTACT_ID_ENABLED_KEY, false);
        this.companyId = settings.getString(COMPANY_ID_KEY, COMPANY_ID_DEFAULT_VALUE);
        this.companyIdEnabled = settings.getBoolean(COMPANY_ID_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String file() {
        return this.file;
    }

    void file(String value) {
        this.file = value;
    }

    String dealId() {
        return this.dealId;
    }

    void dealId(String value) {
        this.dealId = value;
    }

    boolean dealIdEnabled() {
        return this.dealIdEnabled;
    }

    void dealIdEnabled(boolean value) {
        this.dealIdEnabled = value;
    }

    int contactId() {
        return this.contactId;
    }

    void contactId(int value) {
        this.contactId = value;
    }

    boolean contactIdEnabled() {
        return this.contactIdEnabled;
    }

    void contactIdEnabled(boolean value) {
        this.contactIdEnabled = value;
    }

    String companyId() {
        return this.companyId;
    }

    void companyId(String value) {
        this.companyId = value;
    }

    boolean companyIdEnabled() {
        return this.companyIdEnabled;
    }

    void companyIdEnabled(boolean value) {
        this.companyIdEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

