/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.deleteblockeddomain;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class DeleteBlockedDomainNodeSettings {
    private static final String DOMAIN_KEY = "domain";
    private static final String DOMAIN_DEFAULT_VALUE = null;
    private String domain = DOMAIN_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    DeleteBlockedDomainNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(DOMAIN_KEY, this.domain);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.domain = settings.getString(DOMAIN_KEY, DOMAIN_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.domain == null || this.domain.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDomain\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String domain() {
        return this.domain;
    }

    void domain(String value) {
        this.domain = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

