/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.deletelist;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class DeleteListNodeSettings {
    private static final String LIST_ID_KEY = "listId";
    static final Integer LIST_ID_DEFAULT_VALUE = 0;
    static final Integer LIST_ID_MINIMUM_VALUE = null;
    static final Integer LIST_ID_MAXIMUM_VALUE = null;
    private int listId = LIST_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    DeleteListNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(LIST_ID_KEY, this.listId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.listId = settings.getInt(LIST_ID_KEY, LIST_ID_DEFAULT_VALUE.intValue());
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int listId() {
        return this.listId;
    }

    void listId(int value) {
        this.listId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

