/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getcouponcollections;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetCouponCollectionsNodeSettings {
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 50;
    static final Integer LIMIT_MINIMUM_VALUE = 0;
    static final Integer LIMIT_MAXIMUM_VALUE = 100;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = 0;
    static final Integer OFFSET_MAXIMUM_VALUE = null;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    static final String[] SORT_VALUES = new String[]{"asc", "desc"};
    private static final String SORT_KEY = "sort";
    private static final String SORT_DEFAULT_VALUE = "desc";
    private String sort = "desc";
    private static final String SORT_ENABLED_KEY = "sortEnabled";
    private boolean sortEnabled = false;
    static final String[] SORT_BY_VALUES = new String[]{"createdAt", "remainingCoupons", "expirationDate"};
    private static final String SORT_BY_KEY = "sortBy";
    private static final String SORT_BY_DEFAULT_VALUE = "createdAt";
    private String sortBy = "createdAt";
    private static final String SORT_BY_ENABLED_KEY = "sortByEnabled";
    private boolean sortByEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetCouponCollectionsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addString(SORT_KEY, this.sort);
        settings.addBoolean(SORT_ENABLED_KEY, this.sortEnabled);
        settings.addString(SORT_BY_KEY, this.sortBy);
        settings.addBoolean(SORT_BY_ENABLED_KEY, this.sortByEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.sort = settings.getString(SORT_KEY, SORT_DEFAULT_VALUE);
        this.sortEnabled = settings.getBoolean(SORT_ENABLED_KEY, false);
        this.sortBy = settings.getString(SORT_BY_KEY, SORT_BY_DEFAULT_VALUE);
        this.sortByEnabled = settings.getBoolean(SORT_BY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    String sort() {
        return this.sort;
    }

    void sort(String value) {
        this.sort = value;
    }

    boolean sortEnabled() {
        return this.sortEnabled;
    }

    void sortEnabled(boolean value) {
        this.sortEnabled = value;
    }

    String sortBy() {
        return this.sortBy;
    }

    void sortBy(String value) {
        this.sortBy = value;
    }

    boolean sortByEnabled() {
        return this.sortByEnabled;
    }

    void sortByEnabled(boolean value) {
        this.sortByEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

