/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getcrmfiles;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetCrmFilesNodeSettings {
    static final String[] ENTITY_VALUES = new String[]{"companies", "deals", "contacts"};
    private static final String ENTITY_KEY = "entity";
    private static final String ENTITY_DEFAULT_VALUE = ENTITY_VALUES[0];
    private String entity = ENTITY_DEFAULT_VALUE;
    private static final String ENTITY_ENABLED_KEY = "entityEnabled";
    private boolean entityEnabled = false;
    private static final String ENTITY_IDS_KEY = "entityIds";
    private static final String ENTITY_IDS_DEFAULT_VALUE = null;
    private String entityIds = ENTITY_IDS_DEFAULT_VALUE;
    private static final String ENTITY_IDS_ENABLED_KEY = "entityIdsEnabled";
    private boolean entityIdsEnabled = false;
    private static final String DATE_FROM_KEY = "dateFrom";
    static final Integer DATE_FROM_DEFAULT_VALUE = 0;
    static final Integer DATE_FROM_MINIMUM_VALUE = null;
    static final Integer DATE_FROM_MAXIMUM_VALUE = null;
    private int dateFrom = DATE_FROM_DEFAULT_VALUE;
    private static final String DATE_FROM_ENABLED_KEY = "dateFromEnabled";
    private boolean dateFromEnabled = false;
    private static final String DATE_TO_KEY = "dateTo";
    static final Integer DATE_TO_DEFAULT_VALUE = 0;
    static final Integer DATE_TO_MINIMUM_VALUE = null;
    static final Integer DATE_TO_MAXIMUM_VALUE = null;
    private int dateTo = DATE_TO_DEFAULT_VALUE;
    private static final String DATE_TO_ENABLED_KEY = "dateToEnabled";
    private boolean dateToEnabled = false;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = null;
    static final Integer OFFSET_MAXIMUM_VALUE = null;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 50;
    static final Integer LIMIT_MINIMUM_VALUE = null;
    static final Integer LIMIT_MAXIMUM_VALUE = null;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    static final String[] SORT_VALUES = new String[]{"asc", "desc"};
    private static final String SORT_KEY = "sort";
    private static final String SORT_DEFAULT_VALUE = SORT_VALUES[0];
    private String sort = SORT_DEFAULT_VALUE;
    private static final String SORT_ENABLED_KEY = "sortEnabled";
    private boolean sortEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetCrmFilesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ENTITY_KEY, this.entity);
        settings.addBoolean(ENTITY_ENABLED_KEY, this.entityEnabled);
        settings.addString(ENTITY_IDS_KEY, this.entityIds);
        settings.addBoolean(ENTITY_IDS_ENABLED_KEY, this.entityIdsEnabled);
        settings.addInt(DATE_FROM_KEY, this.dateFrom);
        settings.addBoolean(DATE_FROM_ENABLED_KEY, this.dateFromEnabled);
        settings.addInt(DATE_TO_KEY, this.dateTo);
        settings.addBoolean(DATE_TO_ENABLED_KEY, this.dateToEnabled);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addString(SORT_KEY, this.sort);
        settings.addBoolean(SORT_ENABLED_KEY, this.sortEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.entity = settings.getString(ENTITY_KEY, ENTITY_DEFAULT_VALUE);
        this.entityEnabled = settings.getBoolean(ENTITY_ENABLED_KEY, false);
        this.entityIds = settings.getString(ENTITY_IDS_KEY, ENTITY_IDS_DEFAULT_VALUE);
        this.entityIdsEnabled = settings.getBoolean(ENTITY_IDS_ENABLED_KEY, false);
        this.dateFrom = settings.getInt(DATE_FROM_KEY, DATE_FROM_DEFAULT_VALUE.intValue());
        this.dateFromEnabled = settings.getBoolean(DATE_FROM_ENABLED_KEY, false);
        this.dateTo = settings.getInt(DATE_TO_KEY, DATE_TO_DEFAULT_VALUE.intValue());
        this.dateToEnabled = settings.getBoolean(DATE_TO_ENABLED_KEY, false);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.sort = settings.getString(SORT_KEY, SORT_DEFAULT_VALUE);
        this.sortEnabled = settings.getBoolean(SORT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String entity() {
        return this.entity;
    }

    void entity(String value) {
        this.entity = value;
    }

    boolean entityEnabled() {
        return this.entityEnabled;
    }

    void entityEnabled(boolean value) {
        this.entityEnabled = value;
    }

    String entityIds() {
        return this.entityIds;
    }

    void entityIds(String value) {
        this.entityIds = value;
    }

    boolean entityIdsEnabled() {
        return this.entityIdsEnabled;
    }

    void entityIdsEnabled(boolean value) {
        this.entityIdsEnabled = value;
    }

    int dateFrom() {
        return this.dateFrom;
    }

    void dateFrom(int value) {
        this.dateFrom = value;
    }

    boolean dateFromEnabled() {
        return this.dateFromEnabled;
    }

    void dateFromEnabled(boolean value) {
        this.dateFromEnabled = value;
    }

    int dateTo() {
        return this.dateTo;
    }

    void dateTo(int value) {
        this.dateTo = value;
    }

    boolean dateToEnabled() {
        return this.dateToEnabled;
    }

    void dateToEnabled(boolean value) {
        this.dateToEnabled = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    String sort() {
        return this.sort;
    }

    void sort(String value) {
        this.sort = value;
    }

    boolean sortEnabled() {
        return this.sortEnabled;
    }

    void sortEnabled(boolean value) {
        this.sortEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

