/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getfolders;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetFoldersNodeSettings {
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 10;
    static final Integer LIMIT_MINIMUM_VALUE = 0;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = null;
    static final Integer OFFSET_MAXIMUM_VALUE = null;
    private int offset = OFFSET_DEFAULT_VALUE;
    static final String[] SORT_VALUES = new String[]{"asc", "desc"};
    private static final String SORT_KEY = "sort";
    private static final String SORT_DEFAULT_VALUE = "desc";
    private String sort = "desc";
    private static final String SORT_ENABLED_KEY = "sortEnabled";
    private boolean sortEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetFoldersNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addString(SORT_KEY, this.sort);
        settings.addBoolean(SORT_ENABLED_KEY, this.sortEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.sort = settings.getString(SORT_KEY, SORT_DEFAULT_VALUE);
        this.sortEnabled = settings.getBoolean(SORT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    String sort() {
        return this.sort;
    }

    void sort(String value) {
        this.sort = value;
    }

    boolean sortEnabled() {
        return this.sortEnabled;
    }

    void sortEnabled(boolean value) {
        this.sortEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

