/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getsenders;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetSendersNodeSettings {
    private static final String IP_KEY = "ip";
    private static final String IP_DEFAULT_VALUE = null;
    private String ip = IP_DEFAULT_VALUE;
    private static final String IP_ENABLED_KEY = "ipEnabled";
    private boolean ipEnabled = false;
    private static final String DOMAIN_KEY = "domain";
    private static final String DOMAIN_DEFAULT_VALUE = null;
    private String domain = DOMAIN_DEFAULT_VALUE;
    private static final String DOMAIN_ENABLED_KEY = "domainEnabled";
    private boolean domainEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetSendersNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(IP_KEY, this.ip);
        settings.addBoolean(IP_ENABLED_KEY, this.ipEnabled);
        settings.addString(DOMAIN_KEY, this.domain);
        settings.addBoolean(DOMAIN_ENABLED_KEY, this.domainEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.ip = settings.getString(IP_KEY, IP_DEFAULT_VALUE);
        this.ipEnabled = settings.getBoolean(IP_ENABLED_KEY, false);
        this.domain = settings.getString(DOMAIN_KEY, DOMAIN_DEFAULT_VALUE);
        this.domainEnabled = settings.getBoolean(DOMAIN_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String ip() {
        return this.ip;
    }

    void ip(String value) {
        this.ip = value;
    }

    boolean ipEnabled() {
        return this.ipEnabled;
    }

    void ipEnabled(boolean value) {
        this.ipEnabled = value;
    }

    String domain() {
        return this.domain;
    }

    void domain(String value) {
        this.domain = value;
    }

    boolean domainEnabled() {
        return this.domainEnabled;
    }

    void domainEnabled(boolean value) {
        this.domainEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

