/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getsharedtemplateurl;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetSharedTemplateUrlNodeSettings {
    private static final String CAMPAIGN_ID_KEY = "campaignId";
    static final Integer CAMPAIGN_ID_DEFAULT_VALUE = 0;
    static final Integer CAMPAIGN_ID_MINIMUM_VALUE = null;
    static final Integer CAMPAIGN_ID_MAXIMUM_VALUE = null;
    private int campaignId = CAMPAIGN_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetSharedTemplateUrlNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(CAMPAIGN_ID_KEY, this.campaignId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.campaignId = settings.getInt(CAMPAIGN_ID_KEY, CAMPAIGN_ID_DEFAULT_VALUE.intValue());
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int campaignId() {
        return this.campaignId;
    }

    void campaignId(int value) {
        this.campaignId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

