/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.brevo.v3.operation.getwebhooks;

import com.nodepit.nodes.brevo.v3.ResponseMapper;
import com.nodepit.nodes.brevo.v3.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetWebhooksNodeSettings {
    static final String[] TYPE_VALUES = new String[]{"marketing", "transactional", "inbound"};
    private static final String TYPE_KEY = "type";
    private static final String TYPE_DEFAULT_VALUE = "transactional";
    private String type = "transactional";
    private static final String TYPE_ENABLED_KEY = "typeEnabled";
    private boolean typeEnabled = false;
    static final String[] SORT_VALUES = new String[]{"asc", "desc"};
    private static final String SORT_KEY = "sort";
    private static final String SORT_DEFAULT_VALUE = "desc";
    private String sort = "desc";
    private static final String SORT_ENABLED_KEY = "sortEnabled";
    private boolean sortEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetWebhooksNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(TYPE_KEY, this.type);
        settings.addBoolean(TYPE_ENABLED_KEY, this.typeEnabled);
        settings.addString(SORT_KEY, this.sort);
        settings.addBoolean(SORT_ENABLED_KEY, this.sortEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.type = settings.getString(TYPE_KEY, TYPE_DEFAULT_VALUE);
        this.typeEnabled = settings.getBoolean(TYPE_ENABLED_KEY, false);
        this.sort = settings.getString(SORT_KEY, SORT_DEFAULT_VALUE);
        this.sortEnabled = settings.getBoolean(SORT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String type() {
        return this.type;
    }

    void type(String value) {
        this.type = value;
    }

    boolean typeEnabled() {
        return this.typeEnabled;
    }

    void typeEnabled(boolean value) {
        this.typeEnabled = value;
    }

    String sort() {
        return this.sort;
    }

    void sort(String value) {
        this.sort = value;
    }

    boolean sortEnabled() {
        return this.sortEnabled;
    }

    void sortEnabled(boolean value) {
        this.sortEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

