/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.auth.apikeyauthheader;

import com.nodepit.nodes.crunchbase.v4.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyAuthHeaderInterceptorFactory
extends InterceptorFactory<ApiKeyAuthData> {
    public static final String IDENTIFIER = "ApiKeyAuthHeader";
    private static final String API_KEY_PREFIX = null;

    public ApiKeyAuthHeaderInterceptorFactory() {
        super(IDENTIFIER, ApiKeyAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final ApiKeyAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                String apikey = data.apiKey;
                if (API_KEY_PREFIX != null) {
                    apikey = String.valueOf(API_KEY_PREFIX) + " " + apikey;
                }
                Request authRequest = originalRequest.newBuilder().header("X-cb-user-key", apikey).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class ApiKeyAuthData {
        String apiKey;
    }
}

