/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.lookupaninvestment;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class LookupAnInvestmentNodeSettings {
    private static final String ENTITY_ID_KEY = "entityId";
    private static final String ENTITY_ID_DEFAULT_VALUE = null;
    private String entityId = ENTITY_ID_DEFAULT_VALUE;
    private static final String FIELD_IDS_KEY = "fieldIds";
    private static final String FIELD_IDS_DEFAULT_VALUE = null;
    private String fieldIds = FIELD_IDS_DEFAULT_VALUE;
    private static final String FIELD_IDS_ENABLED_KEY = "fieldIdsEnabled";
    private boolean fieldIdsEnabled = false;
    private static final String CARD_IDS_KEY = "cardIds";
    private static final String CARD_IDS_DEFAULT_VALUE = null;
    private String cardIds = CARD_IDS_DEFAULT_VALUE;
    private static final String CARD_IDS_ENABLED_KEY = "cardIdsEnabled";
    private boolean cardIdsEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"properties\":{\"announced_on\":\"rows[0][0]\",\"created_at\":\"rows[0][1]\",\"entity_def_id\":\"rows[0][2]\",\"funding_round_identifier\":\"rows[0][3]\",\"funding_round_investment_type\":\"rows[0][4]\",\"funding_round_money_raised\":\"rows[0][5]\",\"identifier\":\"rows[0][6]\",\"investor_identifier\":\"rows[0][7]\",\"investor_stage\":\"rows[0][8]\",\"investor_type\":\"rows[0][9]\",\"is_lead_investor\":\"rows[0][10]\",\"money_invested\":\"rows[0][11]\",\"name\":\"rows[0][12]\",\"organization_diversity_spotlights\":\"rows[0][13]\",\"organization_identifier\":\"rows[0][14]\",\"partner_identifiers\":\"rows[0][15]\",\"permalink\":\"rows[0][16]\",\"updated_at\":\"rows[0][17]\",\"uuid\":\"rows[0][18]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Announced On", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funding Round Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funding Round Investment Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funding Round Money Raised", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Stage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Type", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Lead Investor", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Money Invested", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization Diversity Spotlights", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Partner Identifiers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    LookupAnInvestmentNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ENTITY_ID_KEY, this.entityId);
        settings.addString(FIELD_IDS_KEY, this.fieldIds);
        settings.addBoolean(FIELD_IDS_ENABLED_KEY, this.fieldIdsEnabled);
        settings.addString(CARD_IDS_KEY, this.cardIds);
        settings.addBoolean(CARD_IDS_ENABLED_KEY, this.cardIdsEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.entityId = settings.getString(ENTITY_ID_KEY, ENTITY_ID_DEFAULT_VALUE);
        this.fieldIds = settings.getString(FIELD_IDS_KEY, FIELD_IDS_DEFAULT_VALUE);
        this.fieldIdsEnabled = settings.getBoolean(FIELD_IDS_ENABLED_KEY, false);
        this.cardIds = settings.getString(CARD_IDS_KEY, CARD_IDS_DEFAULT_VALUE);
        this.cardIdsEnabled = settings.getBoolean(CARD_IDS_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.entityId == null || this.entityId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEntity Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String entityId() {
        return this.entityId;
    }

    void entityId(String value) {
        this.entityId = value;
    }

    String fieldIds() {
        return this.fieldIds;
    }

    void fieldIds(String value) {
        this.fieldIds = value;
    }

    boolean fieldIdsEnabled() {
        return this.fieldIdsEnabled;
    }

    void fieldIdsEnabled(boolean value) {
        this.fieldIdsEnabled = value;
    }

    String cardIds() {
        return this.cardIds;
    }

    void cardIds(String value) {
        this.cardIds = value;
    }

    boolean cardIdsEnabled() {
        return this.cardIdsEnabled;
    }

    void cardIdsEnabled(boolean value) {
        this.cardIdsEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

