/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.searchacquisitionentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import com.nodepit.nodes.crunchbase.v4.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchAcquisitionEntitiesNodeSettings {
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", SearchAcquisitionEntitiesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"acquiree_categories\":\"rows[#2][0]\",\"acquiree_funding_total\":\"rows[#2][1]\",\"acquiree_identifier\":\"rows[#2][2]\",\"acquiree_last_funding_type\":\"rows[#2][3]\",\"acquiree_locations\":\"rows[#2][4]\",\"acquiree_num_funding_rounds\":\"rows[#2][5]\",\"acquiree_revenue_range\":\"rows[#2][6]\",\"acquiree_short_description\":\"rows[#2][7]\",\"acquirer_categories\":\"rows[#2][8]\",\"acquirer_funding_stage\":\"rows[#2][9]\",\"acquirer_funding_total\":\"rows[#2][10]\",\"acquirer_identifier\":\"rows[#2][11]\",\"acquirer_locations\":\"rows[#2][12]\",\"acquirer_num_funding_rounds\":\"rows[#2][13]\",\"acquirer_revenue_range\":\"rows[#2][14]\",\"acquirer_short_description\":\"rows[#2][15]\",\"acquisition_type\":\"rows[#2][16]\",\"announced_on\":\"rows[#2][17]\",\"completed_on\":\"rows[#2][18]\",\"created_at\":\"rows[#2][19]\",\"disposition_of_acquired\":\"rows[#2][20]\",\"entity_def_id\":\"rows[#2][21]\",\"identifier\":\"rows[#2][22]\",\"permalink\":\"rows[#2][23]\",\"price\":\"rows[#2][24]\",\"rank_acquisition\":\"rows[#2][25]\",\"short_description\":\"rows[#2][26]\",\"status\":\"rows[#2][27]\",\"terms\":\"rows[#2][28]\",\"updated_at\":\"rows[#2][29]\",\"uuid\":\"rows[#2][30]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Acquiree Categories", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Funding Total", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Last Funding Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Locations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Num Funding Rounds", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Revenue Range", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquiree Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Categories", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Funding Stage", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Funding Total", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Locations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Num Funding Rounds", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Revenue Range", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquirer Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acquisition Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Announced On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Completed On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Disposition of Acquired", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Price", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Acquisition", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Terms", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchAcquisitionEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

