/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.searchpersonentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import com.nodepit.nodes.crunchbase.v4.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchPersonEntitiesNodeSettings {
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", SearchPersonEntitiesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"aliases\":\"rows[#2][0]\",\"born_on\":\"rows[#2][1]\",\"created_at\":\"rows[#2][2]\",\"description\":\"rows[#2][3]\",\"died_on\":\"rows[#2][4]\",\"entity_def_id\":\"rows[#2][5]\",\"facebook\":\"rows[#2][6]\",\"facet_ids\":\"rows[#2][7]\",\"first_name\":\"rows[#2][8]\",\"gender\":\"rows[#2][9]\",\"identifier\":\"rows[#2][10]\",\"image_id\":\"rows[#2][11]\",\"image_url\":\"rows[#2][12]\",\"investor_stage\":\"rows[#2][13]\",\"investor_type\":\"rows[#2][14]\",\"last_name\":\"rows[#2][15]\",\"layout_id\":\"rows[#2][16]\",\"linkedin\":\"rows[#2][17]\",\"location_group_identifiers\":\"rows[#2][18]\",\"location_identifiers\":\"rows[#2][19]\",\"middle_name\":\"rows[#2][20]\",\"name\":\"rows[#2][21]\",\"num_articles\":\"rows[#2][22]\",\"num_current_advisor_jobs\":\"rows[#2][23]\",\"num_current_jobs\":\"rows[#2][24]\",\"num_diversity_spotlight_investments\":\"rows[#2][25]\",\"num_event_appearances\":\"rows[#2][26]\",\"num_exits\":\"rows[#2][27]\",\"num_exits_ipo\":\"rows[#2][28]\",\"num_founded_organizations\":\"rows[#2][29]\",\"num_investments\":\"rows[#2][30]\",\"num_jobs\":\"rows[#2][31]\",\"num_lead_investments\":\"rows[#2][32]\",\"num_partner_investments\":\"rows[#2][33]\",\"num_past_advisor_jobs\":\"rows[#2][34]\",\"num_past_jobs\":\"rows[#2][35]\",\"num_portfolio_organizations\":\"rows[#2][36]\",\"override_layout_id\":\"rows[#2][37]\",\"permalink\":\"rows[#2][38]\",\"permalink_aliases\":\"rows[#2][39]\",\"primary_job_title\":\"rows[#2][40]\",\"primary_organization\":\"rows[#2][41]\",\"rank_delta_d30\":\"rows[#2][42]\",\"rank_delta_d7\":\"rows[#2][43]\",\"rank_delta_d90\":\"rows[#2][44]\",\"rank_person\":\"rows[#2][45]\",\"rank_principal\":\"rows[#2][46]\",\"short_description\":\"rows[#2][47]\",\"twitter\":\"rows[#2][48]\",\"updated_at\":\"rows[#2][49]\",\"uuid\":\"rows[#2][50]\",\"website\":\"rows[#2][51]\",\"website_url\":\"rows[#2][52]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Aliases", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Born On", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Died On", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Facebook", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Facet Ids", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Gender", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Stage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Type", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Layout Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Linkedin", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Location Group Identifiers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Location Identifiers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Middle Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Articles", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Current Advisor Jobs", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Current Jobs", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Diversity Spotlight Investments", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Event Appearances", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Exits", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Exits Ipo", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Founded Organizations", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Investments", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Jobs", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Lead Investments", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Partner Investments", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Past Advisor Jobs", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Past Jobs", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Portfolio Organizations", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Override Layout Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink Aliases", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Primary Job Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Primary Organization", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Delta D30", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Delta D7", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Delta D90", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Person", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Principal", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Twitter", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Website", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Website Url", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchPersonEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

