/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.suggestmatchingentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SuggestMatchingEntitiesNodeSettings {
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String COLLECTION_IDS_KEY = "collectionIds";
    private static final String COLLECTION_IDS_DEFAULT_VALUE = null;
    private String collectionIds = COLLECTION_IDS_DEFAULT_VALUE;
    private static final String COLLECTION_IDS_ENABLED_KEY = "collectionIdsEnabled";
    private boolean collectionIdsEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 0;
    static final Integer LIMIT_MINIMUM_VALUE = null;
    static final Integer LIMIT_MAXIMUM_VALUE = null;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"identifier\":\"rows[#2][0]\",\"facet_ids\":\"rows[#2][1]\",\"short_description\":\"rows[#2][2]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Facet Ids", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SuggestMatchingEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(QUERY_KEY, this.query);
        settings.addString(COLLECTION_IDS_KEY, this.collectionIds);
        settings.addBoolean(COLLECTION_IDS_ENABLED_KEY, this.collectionIdsEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.collectionIds = settings.getString(COLLECTION_IDS_KEY, COLLECTION_IDS_DEFAULT_VALUE);
        this.collectionIdsEnabled = settings.getBoolean(COLLECTION_IDS_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.query == null || this.query.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cQuery\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    String collectionIds() {
        return this.collectionIds;
    }

    void collectionIds(String value) {
        this.collectionIds = value;
    }

    boolean collectionIdsEnabled() {
        return this.collectionIdsEnabled;
    }

    void collectionIdsEnabled(boolean value) {
        this.collectionIdsEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

