/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.searchfundingroundentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import com.nodepit.nodes.crunchbase.v4.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchFundingRoundEntitiesNodeSettings {
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", SearchFundingRoundEntitiesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"announced_on\":\"rows[#2][0]\",\"closed_on\":\"rows[#2][1]\",\"created_at\":\"rows[#2][2]\",\"entity_def_id\":\"rows[#2][3]\",\"funded_organization_categories\":\"rows[#2][4]\",\"funded_organization_description\":\"rows[#2][5]\",\"funded_organization_diversity_spotlights\":\"rows[#2][6]\",\"funded_organization_funding_stage\":\"rows[#2][7]\",\"funded_organization_funding_total\":\"rows[#2][8]\",\"funded_organization_identifier\":\"rows[#2][9]\",\"funded_organization_location\":\"rows[#2][10]\",\"funded_organization_revenue_range\":\"rows[#2][11]\",\"identifier\":\"rows[#2][12]\",\"image_id\":\"rows[#2][13]\",\"investment_stage\":\"rows[#2][14]\",\"investment_type\":\"rows[#2][15]\",\"investor_identifiers\":\"rows[#2][16]\",\"is_equity\":\"rows[#2][17]\",\"lead_investor_identifiers\":\"rows[#2][18]\",\"money_raised\":\"rows[#2][19]\",\"name\":\"rows[#2][20]\",\"num_investors\":\"rows[#2][21]\",\"num_partners\":\"rows[#2][22]\",\"permalink\":\"rows[#2][23]\",\"post_money_valuation\":\"rows[#2][24]\",\"pre_money_valuation\":\"rows[#2][25]\",\"rank_funding_round\":\"rows[#2][26]\",\"short_description\":\"rows[#2][27]\",\"target_money_raised\":\"rows[#2][28]\",\"updated_at\":\"rows[#2][29]\",\"uuid\":\"rows[#2][30]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Announced On", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Closed On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Categories", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Diversity Spotlights", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Funding Stage", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Funding Total", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Location", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Funded Organization Revenue Range", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investment Stage", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investment Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Investor Identifiers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Equity", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Lead Investor Identifiers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Money Raised", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Investors", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Partners", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Post Money Valuation", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Pre Money Valuation", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Funding Round", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Target Money Raised", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchFundingRoundEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

