/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.searchipoentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import com.nodepit.nodes.crunchbase.v4.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchIpoEntitiesNodeSettings {
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", SearchIpoEntitiesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"amount_raised\":\"rows[#2][0]\",\"created_at\":\"rows[#2][1]\",\"delisted_on\":\"rows[#2][2]\",\"entity_def_id\":\"rows[#2][3]\",\"identifier\":\"rows[#2][4]\",\"image_id\":\"rows[#2][5]\",\"organization_identifier\":\"rows[#2][6]\",\"permalink\":\"rows[#2][7]\",\"rank_ipo\":\"rows[#2][8]\",\"share_price\":\"rows[#2][9]\",\"shares_outstanding\":\"rows[#2][10]\",\"shares_sold\":\"rows[#2][11]\",\"short_description\":\"rows[#2][12]\",\"stock_exchange_symbol\":\"rows[#2][13]\",\"stock_full_symbol\":\"rows[#2][14]\",\"stock_symbol\":\"rows[#2][15]\",\"updated_at\":\"rows[#2][16]\",\"uuid\":\"rows[#2][17]\",\"valuation\":\"rows[#2][18]\",\"went_public_on\":\"rows[#2][19]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Amount Raised", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Delisted On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rank Ipo", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Share Price", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Shares Outstanding", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Shares Sold", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Stock Exchange Symbol", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Stock Full Symbol", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Stock Symbol", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Valuation", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Went Public On", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchIpoEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

