/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.searchjobentities;

import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.SimpleResponseMapper;
import com.nodepit.nodes.crunchbase.v4.TransformToTableMapper;
import com.nodepit.nodes.crunchbase.v4.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchJobEntitiesNodeSettings {
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", SearchJobEntitiesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"entities\":{\"*\":{\"created_at\":\"rows[#2][0]\",\"employee_featured_order\":\"rows[#2][1]\",\"ended_on\":\"rows[#2][2]\",\"entity_def_id\":\"rows[#2][3]\",\"identifier\":\"rows[#2][4]\",\"is_current\":\"rows[#2][5]\",\"job_type\":\"rows[#2][6]\",\"name\":\"rows[#2][7]\",\"organization_identifier\":\"rows[#2][8]\",\"permalink\":\"rows[#2][9]\",\"person_identifier\":\"rows[#2][10]\",\"short_description\":\"rows[#2][11]\",\"started_on\":\"rows[#2][12]\",\"title\":\"rows[#2][13]\",\"updated_at\":\"rows[#2][14]\",\"uuid\":\"rows[#2][15]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Employee Featured Order", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Ended On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entity Def Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Current", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Job Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Person Identifier", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Started On", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uuid", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchJobEntitiesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

