/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.crunchbase.v4.operation.suggestmatchingentities;

import com.nodepit.nodes.crunchbase.v4.LabelButton;
import com.nodepit.nodes.crunchbase.v4.ResponseMapper;
import com.nodepit.nodes.crunchbase.v4.operation.suggestmatchingentities.SuggestMatchingEntitiesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class SuggestMatchingEntitiesNodeDialog
extends NodeDialogPane {
    private final SuggestMatchingEntitiesNodeSettings nodeSettings = new SuggestMatchingEntitiesNodeSettings();
    private JTextField query;
    private JTextField collectionIds;
    private JCheckBox collectionIdsEnabled;
    private JSpinner limit;
    private JCheckBox limitEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    SuggestMatchingEntitiesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Query:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.query = new JTextField(30);
        panel.add((Component)this.query, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Collection Ids:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.collectionIdsEnabled = new JCheckBox();
        this.collectionIdsEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.collectionIdsEnabled.setSelected(!this.collectionIdsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.collectionIdsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.collectionIds = new JTextField(30);
        panel.add((Component)this.collectionIds, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Limit:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.limitEnabled = new JCheckBox();
        this.limitEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.limitEnabled.setSelected(!this.limitEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.limitEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.limit = new JSpinner(new SpinnerNumberModel(SuggestMatchingEntitiesNodeSettings.LIMIT_DEFAULT_VALUE, SuggestMatchingEntitiesNodeSettings.LIMIT_MINIMUM_VALUE, SuggestMatchingEntitiesNodeSettings.LIMIT_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.limit, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(SuggestMatchingEntitiesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.collectionIds.setEnabled(this.collectionIdsEnabled.isSelected());
        this.limit.setEnabled(this.limitEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.query(this.query.getText());
        this.nodeSettings.collectionIds(this.collectionIds.getText());
        this.nodeSettings.collectionIdsEnabled(this.collectionIdsEnabled.isSelected());
        this.nodeSettings.limit((Integer)this.limit.getValue());
        this.nodeSettings.limitEnabled(this.limitEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.query.setText(this.nodeSettings.query());
        this.collectionIds.setText(this.nodeSettings.collectionIds());
        this.collectionIdsEnabled.setSelected(this.nodeSettings.collectionIdsEnabled());
        this.limit.setValue(this.nodeSettings.limit());
        this.limitEnabled.setSelected(this.nodeSettings.limitEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

