/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.distance;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.IntValue;
import org.knime.core.data.LongValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.date.DateAndTimeCell;
import org.knime.core.data.date.DateAndTimeValue;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelDouble;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class EquidistanceTransfomerNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(EquidistanceTransfomerNodeModel.class);
    static final String CFGKEY_DISTANCE = "de.cyface.cfgkey.distance";
    static final String CFGKEY_X_COLUMN = "de.cyface.cfgkey.xcolumn";
    static final String CFGKEY_FX_COLUMN = "de.cyface.cfgkey.fxcolumn";
    static final String CFGKEY_NEW_X_COLUMN = "de.cyface.cfgkey.newxcolumn";
    static final String CFGKEY_NEW_FX_COLUMN = "de.cyface.cfgkey.newfxcolumn";
    static final int DEFAULT_COUNT = 100;
    static final int IN_PORT = 0;
    private final SettingsModelDouble distanceSettings = new SettingsModelDouble("de.cyface.cfgkey.distance", 1.0);
    private final SettingsModelString xColumnSettings = new SettingsModelString("de.cyface.cfgkey.xcolumn", "");
    private final SettingsModelString fxColumnSettings = new SettingsModelString("de.cyface.cfgkey.fxcolumn", "");
    private final SettingsModelString newColumnXSettings = new SettingsModelString("de.cyface.cfgkey.newxcolumn", "");
    private final SettingsModelString newColumFxSettings = new SettingsModelString("de.cyface.cfgkey.newfxcolumn", "");

    protected EquidistanceTransfomerNodeModel() {
        super(1, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        DataTableSpec inputTableSpecification = inData[0].getDataTableSpec();
        int xColumnIndex = inputTableSpecification.findColumnIndex(this.xColumnSettings.getStringValue());
        int fxColumnIndex = inputTableSpecification.findColumnIndex(this.fxColumnSettings.getStringValue());
        DataTableSpec outputTableSpecification = this.createOutputTableSpecification(inputTableSpecification);
        BufferedDataContainer container = exec.createDataContainer(outputTableSpecification);
        double sampleRate = this.distanceSettings.getDoubleValue();
        try {
            Throwable throwable = null;
            Object var11_11 = null;
            try {
                CloseableRowIterator rowIter;
                block16: {
                    rowIter = inData[0].iterator();
                    if (rowIter.hasNext()) break block16;
                    BufferedDataTable[] bufferedDataTableArray = new BufferedDataTable[]{container.getTable()};
                    if (rowIter == null) return bufferedDataTableArray;
                    rowIter.close();
                    return bufferedDataTableArray;
                }
                try {
                    DataRow row = rowIter.next();
                    double i = 1.0;
                    long currentRowIndex = 0L;
                    double x = this.get(row, xColumnIndex);
                    double fx = this.get(row, fxColumnIndex);
                    container.addRowToTable((DataRow)new DefaultRow("Row_" + currentRowIndex++, new DataCell[]{new DoubleCell(x), new DoubleCell(fx)}));
                    double nextInterpolatedX = x + sampleRate;
                    while (rowIter.hasNext()) {
                        exec.checkCanceled();
                        exec.setProgress(i / (double)inData[0].size());
                        i += 1.0;
                        row = rowIter.next();
                        double prevX = x;
                        double prevFx = fx;
                        x = this.get(row, xColumnIndex);
                        fx = this.get(row, fxColumnIndex);
                        while (x >= nextInterpolatedX) {
                            double interpolatedFx = this.linearlyInterpolate(prevX, x, prevFx, fx, nextInterpolatedX);
                            row = new DefaultRow("Row_" + currentRowIndex++, new DataCell[]{new DoubleCell(nextInterpolatedX), new DoubleCell(interpolatedFx)});
                            container.addRowToTable(row);
                            nextInterpolatedX += sampleRate;
                        }
                    }
                    return new BufferedDataTable[]{container.getTable()};
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (rowIter != null) {
                        rowIter.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        finally {
            if (container != null && container.isOpen()) {
                container.close();
            }
        }
    }

    private double linearlyInterpolate(double prevX, double nextX, double prevFx, double nextFx, double interpolationPoint) {
        return prevFx + (nextFx - prevFx) * (interpolationPoint - prevX) / (nextX - prevX);
    }

    private double get(DataRow row, int index) {
        DataCell cell = row.getCell(index);
        if (cell.getType().isCompatible(DoubleValue.class)) {
            return ((DoubleCell)cell).getDoubleValue();
        }
        if (cell.getType().isCompatible(IntValue.class)) {
            return Integer.valueOf(((IntCell)cell).getIntValue()).doubleValue();
        }
        if (cell.getType().isCompatible(LongValue.class)) {
            return Long.valueOf(((LongCell)cell).getLongValue()).doubleValue();
        }
        if (cell.getType().isCompatible(DateAndTimeValue.class)) {
            return Long.valueOf(((DateAndTimeCell)cell).getUTCTimeInMillis()).doubleValue();
        }
        throw new IllegalStateException(String.format("Incompatible Type %s in Row %s and Column %d.", cell.getType().getName(), row.getKey().getString(), index));
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        this.validateInSpec(inSpecs[0]);
        return new DataTableSpec[]{this.createOutputTableSpecification(inSpecs[0])};
    }

    private void validateInSpec(DataTableSpec inSpec) throws InvalidSettingsException {
        if (!(inSpec.containsCompatibleType(DateAndTimeValue.class) || inSpec.containsCompatibleType(LongValue.class) || inSpec.containsCompatibleType(IntValue.class) || inSpec.containsCompatibleType(DoubleValue.class))) {
            throw new InvalidSettingsException("No valid numeric or time column in input table.");
        }
    }

    private DataTableSpec createOutputTableSpecification(DataTableSpec inSpec) {
        DataColumnSpec newXValuesColumnSpec = new DataColumnSpecCreator(this.newColumnXSettings.getStringValue(), DoubleCell.TYPE).createSpec();
        DataColumnSpec newFxValuesColumnSpec = new DataColumnSpecCreator(this.newColumFxSettings.getStringValue(), DoubleCell.TYPE).createSpec();
        return new DataTableSpec(new DataColumnSpec[]{newXValuesColumnSpec, newFxValuesColumnSpec});
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.distanceSettings.saveSettingsTo(settings);
        this.xColumnSettings.saveSettingsTo(settings);
        this.fxColumnSettings.saveSettingsTo(settings);
        this.newColumnXSettings.saveSettingsTo(settings);
        this.newColumFxSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.distanceSettings.loadSettingsFrom(settings);
        this.xColumnSettings.loadSettingsFrom(settings);
        this.fxColumnSettings.loadSettingsFrom(settings);
        this.newColumnXSettings.loadSettingsFrom(settings);
        this.newColumFxSettings.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.distanceSettings.validateSettings(settings);
        this.xColumnSettings.validateSettings(settings);
        this.fxColumnSettings.validateSettings(settings);
        this.newColumnXSettings.validateSettings(settings);
        this.newColumFxSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

