/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.envelope;

import de.cyface.knime.dialog.ColumnSelectionNodeOption;
import de.cyface.knime.nodes.timestamp.TimestampAlignerNodeModel;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public final class EnvelopeNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(TimestampAlignerNodeModel.class);
    private final SettingsModelString inputColumnSelectionModel;

    public EnvelopeNodeModel(ColumnSelectionNodeOption inputColumnSelection) {
        super(1, 1);
        this.inputColumnSelectionModel = inputColumnSelection.getSettingsModel();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.inputColumnSelectionModel.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnSelectionModel.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnSelectionModel.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        BufferedDataContainer outputContainer = exec.createDataContainer(this.createOutputSpec(inputTable.getDataTableSpec()));
        DataTableSpec inputSpecification = inputTable.getSpec();
        int inputColumnIndex = inputSpecification.findColumnIndex(this.inputColumnSelectionModel.getStringValue());
        DataRow previousRow = null;
        DataRow currentRow = null;
        DataRow nextRow = null;
        double itemsProcessed = 0.0;
        for (DataRow row : inputTable) {
            exec.checkCanceled();
            exec.setProgress(itemsProcessed / (double)inputTable.size());
            itemsProcessed += 1.0;
            previousRow = currentRow;
            currentRow = nextRow;
            nextRow = row;
            if (previousRow == null || currentRow == null) continue;
            DataCell previousCell = previousRow.getCell(inputColumnIndex);
            DataCell currentCell = currentRow.getCell(inputColumnIndex);
            DataCell nextCell = nextRow.getCell(inputColumnIndex);
            if (previousCell.isMissing() || currentCell.isMissing() || nextCell.isMissing()) continue;
            double previousValue = ((DoubleCell)previousCell).getDoubleValue();
            double currentValue = ((DoubleCell)currentCell).getDoubleValue();
            double nextValue = ((DoubleCell)nextCell).getDoubleValue();
            if (!(previousValue <= currentValue) || !(nextValue <= currentValue)) continue;
            DataCell[] cells = new DataCell[inputSpecification.getNumColumns()];
            int i = 0;
            while (i < inputSpecification.getNumColumns()) {
                cells[i] = currentRow.getCell(i);
                ++i;
            }
            DefaultRow resultRow = new DefaultRow(currentRow.getKey(), cells);
            outputContainer.addRowToTable((DataRow)resultRow);
        }
        if (outputContainer.size() == 0L) {
            LOGGER.warn((Object)"It seems your input column did not contain any valid data. Maybe there are only missing cells or no maximums.");
        }
        outputContainer.close();
        return new BufferedDataTable[]{outputContainer.getTable()};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{this.createOutputSpec(inSpecs[0])};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inSpec) {
        return inSpec;
    }
}

