/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.export;

import java.nio.ByteBuffer;
import org.knime.core.data.DataRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;

abstract class Point3DSerializer {
    Point3DSerializer() {
    }

    protected abstract int getXColumnIndex();

    protected abstract int getYColumnIndex();

    protected abstract int getZColumnIndex();

    protected abstract int getTimestampColumnIndex();

    byte[] serialize(BufferedDataTable pointTAble, ExecutionContext context, long itemsToProcess) throws CanceledExecutionException {
        ByteBuffer buffer = ByteBuffer.allocate((int)pointTAble.size() * 32);
        double processedItems = 0.0;
        ExecutionMonitor monitor = context.createSubProgress((double)pointTAble.size() / (double)itemsToProcess);
        for (DataRow row : pointTAble) {
            context.checkCanceled();
            monitor.setProgress(processedItems / (double)pointTAble.size());
            processedItems += 1.0;
            buffer.putLong(((LongCell)row.getCell(this.getTimestampColumnIndex())).getLongValue());
            buffer.putDouble(((DoubleCell)row.getCell(this.getXColumnIndex())).getDoubleValue());
            buffer.putDouble(((DoubleCell)row.getCell(this.getYColumnIndex())).getDoubleValue());
            buffer.putDouble(((DoubleCell)row.getCell(this.getZColumnIndex())).getDoubleValue());
        }
        byte[] payload = new byte[buffer.capacity()];
        ((ByteBuffer)buffer.duplicate().clear()).get(payload);
        return payload;
    }
}

